/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck;

import ch.iterate.mountainduck.ShutdownTimer;
import java.time.Duration;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractShutdownTimer
implements ShutdownTimer {
    private static final Logger log = LogManager.getLogger((String)AbstractShutdownTimer.class.getName());
    private final Duration delay;
    private final Timer timer = new Timer("shutdown", true);

    public AbstractShutdownTimer() {
        this(Duration.ofMinutes(10L));
    }

    public AbstractShutdownTimer(Duration delay) {
        this.delay = delay;
    }

    public Duration register(final Callback callback) {
        if (log.isInfoEnabled()) {
            log.info(String.format("Register shutdown application hook after %s", this.delay));
        }
        try {
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    log.warn(String.format("Shutdown application after %s", AbstractShutdownTimer.this.delay));
                    callback.done();
                }
            }, this.delay.toMillis());
        }
        catch (IllegalStateException e) {
            log.warn(String.format("Failure scheduling timer %s", this.timer));
        }
        return this.delay;
    }

    @Override
    public void unregister() {
        if (log.isInfoEnabled()) {
            log.info(String.format("Cancel shutdown timer %s", this.timer));
        }
        this.timer.cancel();
    }

    public static interface Callback {
        public void done();
    }
}

