/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DefaultPathContainerService;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AttributesAdapter;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.AbstractHttpWriteFeature;
import ch.cyberduck.core.http.DelayedHttpEntityCallable;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.ChecksumComputeFactory;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.openstack.SwiftAttributesFinderFeature;
import ch.cyberduck.core.openstack.SwiftExceptionMappingService;
import ch.cyberduck.core.openstack.SwiftObjectListService;
import ch.cyberduck.core.openstack.SwiftRegionService;
import ch.cyberduck.core.openstack.SwiftSegmentService;
import ch.cyberduck.core.openstack.SwiftSession;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.iterate.openstack.swift.Client;
import ch.iterate.openstack.swift.exception.GenericException;
import ch.iterate.openstack.swift.model.StorageObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SwiftWriteFeature
extends AbstractHttpWriteFeature<StorageObject>
implements Write<StorageObject> {
    private static final Logger log = LogManager.getLogger(SwiftSession.class);
    private final PathContainerService containerService = new DefaultPathContainerService();
    private final SwiftSession session;
    private final SwiftRegionService regionService;

    public SwiftWriteFeature(SwiftSession session, SwiftRegionService regionService) {
        super((AttributesAdapter)new SwiftAttributesFinderFeature(session, regionService));
        this.session = session;
        this.regionService = regionService;
    }

    public HttpResponseOutputStream<StorageObject> write(final Path file, final TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        DelayedHttpEntityCallable<StorageObject> command = new DelayedHttpEntityCallable<StorageObject>(){

            public StorageObject call(AbstractHttpEntity entity) throws BackgroundException {
                try {
                    HashMap headers = new HashMap(status.getMetadata());
                    Checksum checksum = status.getChecksum();
                    String etag = ((Client)SwiftWriteFeature.this.session.getClient()).storeObject(SwiftWriteFeature.this.regionService.lookup(file), SwiftWriteFeature.this.containerService.getContainer(file).getName(), SwiftWriteFeature.this.containerService.getKey(file), (HttpEntity)entity, headers, checksum.algorithm == HashAlgorithm.md5 ? checksum.hash : null);
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Saved object %s with checksum %s", file, etag));
                    }
                    StorageObject stored = new StorageObject(SwiftWriteFeature.this.containerService.getKey(file));
                    stored.setMd5sum(etag);
                    stored.setSize(Long.valueOf(status.getLength()));
                    return stored;
                }
                catch (GenericException e) {
                    throw new SwiftExceptionMappingService().map("Upload {0} failed", e, file);
                }
                catch (IOException e) {
                    throw new DefaultIOExceptionMappingService().map("Upload {0} failed", (Throwable)e, file);
                }
            }

            public long getContentLength() {
                return status.getLength();
            }
        };
        return this.write(file, status, (DelayedHttpEntityCallable)command);
    }

    public Write.Append append(Path file, TransferStatus status) throws BackgroundException {
        List segments;
        long size = 0L;
        try {
            segments = new SwiftObjectListService(this.session, this.regionService).list(new SwiftSegmentService(this.session, this.regionService).getSegmentsDirectory(file), (ListProgressListener)new DisabledListProgressListener()).toList();
            if (segments.isEmpty()) {
                return Write.override;
            }
        }
        catch (NotfoundException e) {
            return Write.override;
        }
        for (Path segment : segments) {
            size += segment.attributes().getSize();
        }
        return new Write.Append(true).withStatus(status).withSize(Long.valueOf(size));
    }

    public ChecksumCompute checksum(Path file, TransferStatus status) {
        return ChecksumComputeFactory.get((HashAlgorithm)HashAlgorithm.md5);
    }
}

