/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpUploadFeature;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.openstack.SwiftLargeObjectUploadFeature;
import ch.cyberduck.core.openstack.SwiftMultipleDeleteFeature;
import ch.cyberduck.core.openstack.SwiftRegionService;
import ch.cyberduck.core.openstack.SwiftSegmentService;
import ch.cyberduck.core.openstack.SwiftSession;
import ch.cyberduck.core.openstack.SwiftSmallObjectUploadFeature;
import ch.cyberduck.core.openstack.SwiftWriteFeature;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.iterate.openstack.swift.model.StorageObject;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SwiftThresholdUploadService
implements Upload<StorageObject> {
    private static final Logger log = LogManager.getLogger(SwiftThresholdUploadService.class);
    private final SwiftSession session;
    private final SwiftRegionService regionService;
    private final Long threshold;
    private Write<StorageObject> writer;

    public SwiftThresholdUploadService(SwiftSession session, SwiftRegionService regionService, SwiftWriteFeature writer) {
        this(session, regionService, writer, new HostPreferences(session.getHost()).getLong("openstack.upload.largeobject.threshold"));
    }

    public SwiftThresholdUploadService(SwiftSession session, SwiftRegionService regionService, SwiftWriteFeature writer, Long threshold) {
        this.session = session;
        this.regionService = regionService;
        this.writer = writer;
        this.threshold = threshold;
    }

    public Write.Append append(Path file, TransferStatus status) throws BackgroundException {
        return this.writer.append(file, status);
    }

    public StorageObject upload(Path file, Local local, BandwidthThrottle throttle, StreamListener listener, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        HttpUploadFeature feature;
        if (status.getLength() > this.threshold) {
            if (!new HostPreferences(this.session.getHost()).getBoolean("openstack.upload.largeobject") && status.getLength() < new HostPreferences(this.session.getHost()).getLong("openstack.upload.largeobject.required.threshold")) {
                log.warn("Large upload is disabled with property openstack.upload.largeobject");
                return (StorageObject)new SwiftSmallObjectUploadFeature(this.session, this.writer).upload(file, local, throttle, listener, status, callback);
            }
            feature = new SwiftLargeObjectUploadFeature(this.session, this.regionService, this.writer, new HostPreferences(this.session.getHost()).getLong("openstack.upload.largeobject.size"), new HostPreferences(this.session.getHost()).getInteger("openstack.upload.largeobject.concurrency"));
        } else {
            feature = new SwiftSmallObjectUploadFeature(this.session, this.writer);
        }
        ArrayList<Path> segments = new ArrayList<Path>();
        if (new HostPreferences(this.session.getHost()).getBoolean("openstack.upload.largeobject.cleanup") && !status.isAppend()) {
            segments.addAll(new SwiftSegmentService(this.session, this.regionService).list(file));
        }
        StorageObject checksum = (StorageObject)feature.upload(file, local, throttle, listener, status, callback);
        if (!segments.isEmpty()) {
            new SwiftMultipleDeleteFeature(this.session).delete(segments, (PasswordCallback)callback, (Delete.Callback)new Delete.DisabledCallback());
        }
        return checksum;
    }

    public Upload<StorageObject> withWriter(Write<StorageObject> writer) {
        this.writer = writer;
        return this;
    }
}

