/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.openstack.SwiftDeleteFeature;
import ch.cyberduck.core.openstack.SwiftMultipleDeleteFeature;
import ch.cyberduck.core.openstack.SwiftRegionService;
import ch.cyberduck.core.openstack.SwiftSegmentService;
import ch.cyberduck.core.openstack.SwiftSession;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.Map;

public class SwiftThresholdDeleteFeature
implements Delete {
    private final SwiftSession session;
    private final SwiftSegmentService segmentService;
    private final SwiftRegionService regionService;

    public SwiftThresholdDeleteFeature(SwiftSession session, SwiftSegmentService segmentService, SwiftRegionService regionService) {
        this.session = session;
        this.segmentService = segmentService;
        this.regionService = regionService;
    }

    public void delete(Map<Path, TransferStatus> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        if (files.size() == 1) {
            new SwiftDeleteFeature(this.session, this.regionService).delete(files, prompt, callback);
        } else {
            new SwiftMultipleDeleteFeature(this.session, this.segmentService, this.regionService).delete(files, prompt, callback);
        }
    }
}

