/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.cdn.Distribution;
import ch.cyberduck.core.cdn.DistributionConfiguration;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Headers;
import ch.cyberduck.core.features.Location;
import ch.cyberduck.core.features.Metadata;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Scheduler;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpSession;
import ch.cyberduck.core.openstack.SwiftAccountLoader;
import ch.cyberduck.core.openstack.SwiftAttributesFinderFeature;
import ch.cyberduck.core.openstack.SwiftAuthenticationService;
import ch.cyberduck.core.openstack.SwiftDirectoryFeature;
import ch.cyberduck.core.openstack.SwiftDistributionConfiguration;
import ch.cyberduck.core.openstack.SwiftDistributionConfigurationLoader;
import ch.cyberduck.core.openstack.SwiftExceptionMappingService;
import ch.cyberduck.core.openstack.SwiftFindFeature;
import ch.cyberduck.core.openstack.SwiftLargeUploadWriteFeature;
import ch.cyberduck.core.openstack.SwiftListService;
import ch.cyberduck.core.openstack.SwiftLocationFeature;
import ch.cyberduck.core.openstack.SwiftMetadataFeature;
import ch.cyberduck.core.openstack.SwiftMoveFeature;
import ch.cyberduck.core.openstack.SwiftReadFeature;
import ch.cyberduck.core.openstack.SwiftRegionService;
import ch.cyberduck.core.openstack.SwiftSegmentCopyService;
import ch.cyberduck.core.openstack.SwiftSegmentService;
import ch.cyberduck.core.openstack.SwiftThresholdDeleteFeature;
import ch.cyberduck.core.openstack.SwiftThresholdUploadService;
import ch.cyberduck.core.openstack.SwiftTouchFeature;
import ch.cyberduck.core.openstack.SwiftUrlProvider;
import ch.cyberduck.core.openstack.SwiftWriteFeature;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.shared.DelegatingSchedulerFeature;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.threading.CancelCallback;
import ch.iterate.openstack.swift.Client;
import ch.iterate.openstack.swift.exception.GenericException;
import ch.iterate.openstack.swift.method.AuthenticationRequest;
import ch.iterate.openstack.swift.model.AccountInfo;
import ch.iterate.openstack.swift.model.Region;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SwiftSession
extends HttpSession<Client> {
    private static final Logger log = LogManager.getLogger(SwiftSession.class);
    private final SwiftRegionService regionService = new SwiftRegionService(this);
    private final Map<Region, AccountInfo> accounts = new ConcurrentHashMap<Region, AccountInfo>();
    private final Map<Path, Set<Distribution>> distributions = new ConcurrentHashMap<Path, Set<Distribution>>();

    public SwiftSession(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, trust, key);
    }

    protected Client connect(Proxy proxy, HostKeyCallback key, LoginCallback prompt, CancelCallback cancel) {
        HttpClientBuilder pool = this.builder.build(proxy, (TranscriptListener)this, prompt);
        pool.disableContentCompression();
        return new Client(pool.build());
    }

    protected void logout() throws BackgroundException {
        try {
            ((Client)this.client).disconnect();
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public void login(Proxy proxy, LoginCallback prompt, CancelCallback cancel) throws BackgroundException {
        try {
            Set<? extends AuthenticationRequest> options = new SwiftAuthenticationService().getRequest(this.host, prompt);
            Iterator<? extends AuthenticationRequest> iter = options.iterator();
            while (iter.hasNext()) {
                try {
                    AuthenticationRequest auth = iter.next();
                    if (log.isInfoEnabled()) {
                        log.info(String.format("Attempt authentication with %s", auth));
                    }
                    ((Client)this.client).authenticate(auth);
                    break;
                }
                catch (GenericException failure) {
                    BackgroundException reason = new SwiftExceptionMappingService().map(failure);
                    if (reason instanceof LoginFailureException || reason instanceof AccessDeniedException || reason instanceof InteroperabilityException) {
                        if (!iter.hasNext()) {
                            throw failure;
                        }
                    } else {
                        throw failure;
                    }
                    cancel.verify();
                }
            }
        }
        catch (GenericException e) {
            throw new SwiftExceptionMappingService().map(e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public <T> T _getFeature(Class<T> type) {
        if (type == ListService.class) {
            return (T)new SwiftListService(this, this.regionService);
        }
        if (type == Read.class) {
            return (T)new SwiftReadFeature(this, this.regionService);
        }
        if (type == MultipartWrite.class) {
            return (T)new SwiftLargeUploadWriteFeature(this, this.regionService, new SwiftSegmentService(this, this.regionService));
        }
        if (type == Write.class) {
            return (T)((Object)new SwiftWriteFeature(this, this.regionService));
        }
        if (type == Upload.class) {
            return (T)new SwiftThresholdUploadService(this, this.regionService, new SwiftWriteFeature(this, this.regionService));
        }
        if (type == Directory.class) {
            return (T)new SwiftDirectoryFeature(this, this.regionService, new SwiftWriteFeature(this, this.regionService));
        }
        if (type == Delete.class) {
            return (T)new SwiftThresholdDeleteFeature(this, new SwiftSegmentService(this, this.regionService), this.regionService);
        }
        if (type == Headers.class) {
            return (T)new SwiftMetadataFeature(this, this.regionService);
        }
        if (type == Metadata.class) {
            return (T)new SwiftMetadataFeature(this, this.regionService);
        }
        if (type == Copy.class) {
            return (T)new SwiftSegmentCopyService(this, this.regionService);
        }
        if (type == Move.class) {
            return (T)new SwiftMoveFeature(this, this.regionService);
        }
        if (type == Touch.class) {
            return (T)((Object)new SwiftTouchFeature(this, this.regionService));
        }
        if (type == Location.class) {
            return (T)new SwiftLocationFeature(this);
        }
        if (type == DistributionConfiguration.class) {
            for (Region region : this.accounts.keySet()) {
                if (null != region.getCDNManagementUrl()) continue;
                log.warn(String.format("Missing CDN Management URL for region %s", region.getRegionId()));
                return null;
            }
            return (T)new SwiftDistributionConfiguration(this, this.regionService){

                @Override
                public Distribution read(Path container, Distribution.Method method, LoginCallback prompt) throws BackgroundException {
                    Distribution distribution = super.read(container, method, prompt);
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Cache distribution %s", distribution));
                    }
                    Set cached = SwiftSession.this.distributions.getOrDefault(container, new HashSet());
                    cached.add(distribution);
                    SwiftSession.this.distributions.put(container, cached);
                    return distribution;
                }
            };
        }
        if (type == UrlProvider.class) {
            return (T)new SwiftUrlProvider(this, this.accounts, this.regionService, this.distributions);
        }
        if (type == Find.class) {
            return (T)new SwiftFindFeature(this);
        }
        if (type == AttributesFinder.class) {
            return (T)new SwiftAttributesFinderFeature(this, this.regionService);
        }
        if (type == Scheduler.class) {
            return (T)new DelegatingSchedulerFeature(new Scheduler[]{new SwiftAccountLoader(this){

                @Override
                public Map<Region, AccountInfo> operate(PasswordCallback callback, Path container) throws BackgroundException {
                    Object result = super.operate(callback, container);
                    SwiftSession.this.accounts.putAll(result);
                    return result;
                }
            }, new SwiftDistributionConfigurationLoader(this)});
        }
        return (T)super._getFeature(type);
    }
}

