/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DefaultPathContainerService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.date.ISO8601DateParser;
import ch.cyberduck.core.date.InvalidDateException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.openstack.SwiftExceptionMappingService;
import ch.cyberduck.core.openstack.SwiftRegionService;
import ch.cyberduck.core.openstack.SwiftSession;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.iterate.openstack.swift.Client;
import ch.iterate.openstack.swift.exception.GenericException;
import ch.iterate.openstack.swift.model.StorageObject;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SwiftSegmentService {
    private static final Logger log = LogManager.getLogger(SwiftSegmentService.class);
    private final SwiftSession session;
    private final PathContainerService containerService = new DefaultPathContainerService();
    private final ISO8601DateParser dateParser = new ISO8601DateParser();
    private final String prefix;
    private final SwiftRegionService regionService;

    public SwiftSegmentService(SwiftSession session) {
        this(session, new SwiftRegionService(session));
    }

    public SwiftSegmentService(SwiftSession session, String prefix) {
        this(session, new SwiftRegionService(session), prefix);
    }

    public SwiftSegmentService(SwiftSession session, SwiftRegionService regionService) {
        this(session, regionService, new HostPreferences(session.getHost()).getProperty("openstack.upload.largeobject.segments.prefix"));
    }

    public SwiftSegmentService(SwiftSession session, SwiftRegionService regionService, String prefix) {
        this.session = session;
        this.prefix = prefix;
        this.regionService = regionService;
    }

    public List<Path> list(Path file) throws BackgroundException {
        try {
            Path container = this.containerService.getContainer(file);
            Map segments = ((Client)this.session.getClient()).listObjectSegments(this.regionService.lookup(container), container.getName(), this.containerService.getKey(file));
            if (null == segments) {
                return Collections.emptyList();
            }
            ArrayList<Path> objects = new ArrayList<Path>();
            for (String containerName : segments.keySet()) {
                Path containerPath = new Path(containerName, container.getType(), container.attributes());
                for (StorageObject s : (List)segments.get(containerName)) {
                    Path segment = new Path(containerPath, s.getName(), EnumSet.of(AbstractPath.Type.file));
                    segment.attributes().setSize(s.getSize().longValue());
                    try {
                        segment.attributes().setModificationDate(this.dateParser.parse(s.getLastModified()).getTime());
                    }
                    catch (InvalidDateException e) {
                        log.warn(String.format("%s is not ISO 8601 format %s", s.getLastModified(), e.getMessage()));
                    }
                    if (StringUtils.isNotBlank((CharSequence)s.getMd5sum())) {
                        segment.attributes().setChecksum(Checksum.parse((String)s.getMd5sum()));
                    }
                    objects.add(segment);
                }
            }
            return objects;
        }
        catch (GenericException e) {
            throw new SwiftExceptionMappingService().map("Failure to read attributes of {0}", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Failure to read attributes of {0}", (Throwable)e, file);
        }
    }

    public Path getSegmentsDirectory(Path file) {
        return new Path(file.getParent(), String.format("%s%s", this.prefix, file.getName()), EnumSet.of(AbstractPath.Type.directory));
    }

    public Path getSegment(Path file, int segmentNumber) {
        return new Path(this.getSegmentsDirectory(file), String.format("%08d", segmentNumber), EnumSet.of(AbstractPath.Type.file));
    }

    public String manifest(String container, List<StorageObject> objects) {
        JsonArray manifestSLO = new JsonArray();
        for (StorageObject s : objects) {
            JsonObject segmentJSON = new JsonObject();
            segmentJSON.addProperty("path", String.format("/%s/%s", container, s.getName()));
            segmentJSON.addProperty("etag", s.getMd5sum());
            segmentJSON.addProperty("size_bytes", (Number)s.getSize());
            manifestSLO.add((JsonElement)segmentJSON);
        }
        return manifestSLO.toString();
    }

    public Checksum checksum(ChecksumCompute checksum, List<StorageObject> objects) throws BackgroundException {
        StringBuilder concatenated = new StringBuilder();
        for (StorageObject s : objects) {
            concatenated.append(s.getMd5sum());
        }
        return checksum.compute(IOUtils.toInputStream((String)concatenated.toString(), (Charset)Charset.defaultCharset()), new TransferStatus());
    }
}

