/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultPathContainerService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.openstack.SwiftDefaultCopyFeature;
import ch.cyberduck.core.openstack.SwiftLargeObjectCopyFeature;
import ch.cyberduck.core.openstack.SwiftRegionService;
import ch.cyberduck.core.openstack.SwiftSegmentService;
import ch.cyberduck.core.openstack.SwiftSession;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.List;

public class SwiftSegmentCopyService
implements Copy {
    private final PathContainerService containerService = new DefaultPathContainerService();
    private final SwiftSession session;
    private final SwiftRegionService regionService;

    public SwiftSegmentCopyService(SwiftSession session) {
        this(session, new SwiftRegionService(session));
    }

    public SwiftSegmentCopyService(SwiftSession session, SwiftRegionService regionService) {
        this.session = session;
        this.regionService = regionService;
    }

    public Path copy(Path source, Path target, TransferStatus status, ConnectionCallback callback, StreamListener listener) throws BackgroundException {
        SwiftSegmentService segmentService = new SwiftSegmentService(this.session);
        List<Path> segments = segmentService.list(source);
        if (segments.isEmpty()) {
            return new SwiftDefaultCopyFeature(this.session, this.regionService).copy(source, target, status, callback, listener);
        }
        return new SwiftLargeObjectCopyFeature(this.session, this.regionService, segmentService).copy(source, segments, target, status, callback, listener);
    }

    public boolean isSupported(Path source, Path target) {
        return !this.containerService.isContainer(source) && !this.containerService.isContainer(target);
    }
}

