/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DefaultPathContainerService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.http.HttpMethodReleaseInputStream;
import ch.cyberduck.core.http.HttpRange;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.openstack.SwiftExceptionMappingService;
import ch.cyberduck.core.openstack.SwiftRegionService;
import ch.cyberduck.core.openstack.SwiftSession;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.iterate.openstack.swift.Client;
import ch.iterate.openstack.swift.Response;
import ch.iterate.openstack.swift.exception.GenericException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SwiftReadFeature
implements Read {
    private static final Logger log = LogManager.getLogger(SwiftReadFeature.class);
    private final PathContainerService containerService = new DefaultPathContainerService();
    private final SwiftSession session;
    private final SwiftRegionService regionService;

    public SwiftReadFeature(SwiftSession session, SwiftRegionService regionService) {
        this.session = session;
        this.regionService = regionService;
    }

    public InputStream read(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            HttpRange range;
            status.setChecksum(Checksum.NONE);
            Response response = status.isAppend() ? (-1L == (range = HttpRange.withStatus((TransferStatus)status)).getEnd() ? ((Client)this.session.getClient()).getObject(this.regionService.lookup(file), this.containerService.getContainer(file).getName(), this.containerService.getKey(file), range.getStart()) : ((Client)this.session.getClient()).getObject(this.regionService.lookup(file), this.containerService.getContainer(file).getName(), this.containerService.getKey(file), range.getStart(), range.getLength())) : ((Client)this.session.getClient()).getObject(this.regionService.lookup(file), this.containerService.getContainer(file).getName(), this.containerService.getKey(file));
            return new HttpMethodReleaseInputStream(response.getResponse(), status);
        }
        catch (GenericException e) {
            throw new SwiftExceptionMappingService().map("Download {0} failed", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e, file);
        }
    }
}

