/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DefaultPathContainerService;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.collections.Partition;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.openstack.SwiftDeleteFeature;
import ch.cyberduck.core.openstack.SwiftExceptionMappingService;
import ch.cyberduck.core.openstack.SwiftRegionService;
import ch.cyberduck.core.openstack.SwiftSegmentService;
import ch.cyberduck.core.openstack.SwiftSession;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.iterate.openstack.swift.Client;
import ch.iterate.openstack.swift.exception.GenericException;
import ch.iterate.openstack.swift.model.Region;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SwiftMultipleDeleteFeature
implements Delete {
    private final SwiftSession session;
    private final PathContainerService containerService = new DefaultPathContainerService();
    private final SwiftSegmentService segmentService;
    private final SwiftRegionService regionService;

    public SwiftMultipleDeleteFeature(SwiftSession session) {
        this(session, new SwiftSegmentService(session), new SwiftRegionService(session));
    }

    public SwiftMultipleDeleteFeature(SwiftSession session, SwiftSegmentService segmentService, SwiftRegionService regionService) {
        this.segmentService = segmentService;
        this.regionService = regionService;
        this.session = session;
    }

    public void delete(Map<Path, TransferStatus> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        ArrayList<String> keys;
        HashMap containers = new HashMap();
        for (Path path : files.keySet()) {
            if (this.containerService.isContainer(path)) continue;
            callback.delete(path);
            Path container = this.containerService.getContainer(path);
            if (containers.containsKey(container)) {
                ((List)containers.get(container)).add(this.containerService.getKey(path));
                continue;
            }
            keys = new ArrayList<String>();
            keys.add(this.containerService.getKey(path));
            for (Path segment : this.segmentService.list(path)) {
                keys.add(this.containerService.getKey(segment));
            }
            containers.put(container, keys);
        }
        try {
            for (Map.Entry entry : containers.entrySet()) {
                Region region = this.regionService.lookup((Path)entry.getKey());
                keys = (ArrayList<String>)entry.getValue();
                for (List partition : new Partition(keys, new HostPreferences(this.session.getHost()).getInteger("openstack.delete.multiple.partition"))) {
                    ((Client)this.session.getClient()).deleteObjects(region, ((Path)entry.getKey()).getName(), partition);
                }
            }
        }
        catch (GenericException e) {
            if (new SwiftExceptionMappingService().map(e) instanceof InteroperabilityException) {
                new SwiftDeleteFeature(this.session, this.regionService).delete(files, prompt, callback);
                return;
            }
            throw new SwiftExceptionMappingService().map("Cannot delete {0}", e, files.keySet().iterator().next());
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Cannot delete {0}", (Throwable)e, files.keySet().iterator().next());
        }
        for (Path path : files.keySet()) {
            if (!this.containerService.isContainer(path)) continue;
            callback.delete(path);
            try {
                ((Client)this.session.getClient()).deleteContainer(this.regionService.lookup(path), this.containerService.getContainer(path).getName());
            }
            catch (GenericException e) {
                throw new SwiftExceptionMappingService().map("Cannot delete {0}", e, path);
            }
            catch (IOException e) {
                throw new DefaultIOExceptionMappingService().map("Cannot delete {0}", (Throwable)e, path);
            }
        }
    }
}

