/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultPathContainerService;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.io.DisabledStreamListener;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.openstack.SwiftDefaultCopyFeature;
import ch.cyberduck.core.openstack.SwiftDeleteFeature;
import ch.cyberduck.core.openstack.SwiftRegionService;
import ch.cyberduck.core.openstack.SwiftSegmentCopyService;
import ch.cyberduck.core.openstack.SwiftSession;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.Collections;

public class SwiftMoveFeature
implements Move {
    private final PathContainerService containerService = new DefaultPathContainerService();
    private final SwiftSession session;
    private final SwiftRegionService regionService;

    public SwiftMoveFeature(SwiftSession session) {
        this(session, new SwiftRegionService(session));
    }

    public SwiftMoveFeature(SwiftSession session, SwiftRegionService regionService) {
        this.session = session;
        this.regionService = regionService;
    }

    public Path move(Path file, Path renamed, TransferStatus status, Delete.Callback callback, ConnectionCallback connectionCallback) throws BackgroundException {
        if (this.containerService.getContainer(file).equals((Object)this.containerService.getContainer(renamed))) {
            Path rename = new SwiftDefaultCopyFeature(this.session, this.regionService).copy(file, renamed, new TransferStatus().withLength(file.attributes().getSize()), connectionCallback, (StreamListener)new DisabledStreamListener());
            new SwiftDeleteFeature(this.session).delete(Collections.singletonMap(file, status), (PasswordCallback)connectionCallback, callback, false);
            return rename;
        }
        Path copy = new SwiftSegmentCopyService(this.session, this.regionService).copy(file, renamed, new TransferStatus().withLength(file.attributes().getSize()), connectionCallback, (StreamListener)new DisabledStreamListener());
        new SwiftDeleteFeature(this.session).delete(Collections.singletonMap(file, status), (PasswordCallback)connectionCallback, callback);
        return copy;
    }

    public boolean isSupported(Path source, Path target) {
        return !this.containerService.isContainer(source);
    }
}

