/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DefaultPathContainerService;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Headers;
import ch.cyberduck.core.openstack.SwiftAttributesFinderFeature;
import ch.cyberduck.core.openstack.SwiftExceptionMappingService;
import ch.cyberduck.core.openstack.SwiftRegionService;
import ch.cyberduck.core.openstack.SwiftSession;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.iterate.openstack.swift.Client;
import ch.iterate.openstack.swift.exception.GenericException;
import ch.iterate.openstack.swift.model.ContainerMetadata;
import java.io.IOException;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SwiftMetadataFeature
implements Headers {
    private static final Logger log = LogManager.getLogger(SwiftMetadataFeature.class);
    private final SwiftSession session;
    private final PathContainerService containerService = new DefaultPathContainerService();
    private final SwiftRegionService regionService;

    public SwiftMetadataFeature(SwiftSession session) {
        this(session, new SwiftRegionService(session));
    }

    public SwiftMetadataFeature(SwiftSession session, SwiftRegionService regionService) {
        this.session = session;
        this.regionService = regionService;
    }

    public Map<String, String> getDefault(Local local) {
        return new HostPreferences(this.session.getHost()).getMap("openstack.metadata.default");
    }

    public Map<String, String> getMetadata(Path file) throws BackgroundException {
        try {
            if (this.containerService.isContainer(file)) {
                ContainerMetadata meta = ((Client)this.session.getClient()).getContainerMetaData(this.regionService.lookup(file), this.containerService.getContainer(file).getName());
                return meta.getMetaData();
            }
            return new SwiftAttributesFinderFeature(this.session).find(file).getMetadata();
        }
        catch (GenericException e) {
            throw new SwiftExceptionMappingService().map("Failure to read attributes of {0}", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Failure to read attributes of {0}", (Throwable)e, file);
        }
    }

    public void setMetadata(Path file, TransferStatus status) throws BackgroundException {
        try {
            if (this.containerService.isContainer(file)) {
                for (Map.Entry entry : file.attributes().getMetadata().entrySet()) {
                    if (status.getMetadata().containsKey(entry.getKey())) continue;
                    log.debug(String.format("Remove metadata with key %s", entry.getKey()));
                    status.getMetadata().put((String)entry.getKey(), "");
                }
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Write metadata %s for file %s", status, file));
                }
                ((Client)this.session.getClient()).updateContainerMetadata(this.regionService.lookup(file), this.containerService.getContainer(file).getName(), status.getMetadata());
            } else {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Write metadata %s for file %s", status, file));
                }
                ((Client)this.session.getClient()).updateObjectMetadata(this.regionService.lookup(file), this.containerService.getContainer(file).getName(), this.containerService.getKey(file), status.getMetadata());
            }
        }
        catch (GenericException e) {
            throw new SwiftExceptionMappingService().map("Failure to write attributes of {0}", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Failure to write attributes of {0}", (Throwable)e, file);
        }
    }
}

