/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DefaultPathContainerService;
import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesAdapter;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.io.MemorySegementingOutputStream;
import ch.cyberduck.core.io.StreamCancelation;
import ch.cyberduck.core.openstack.SwiftAttributesFinderFeature;
import ch.cyberduck.core.openstack.SwiftExceptionMappingService;
import ch.cyberduck.core.openstack.SwiftRegionService;
import ch.cyberduck.core.openstack.SwiftSegmentService;
import ch.cyberduck.core.openstack.SwiftSession;
import ch.cyberduck.core.openstack.SwiftWriteFeature;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.threading.BackgroundExceptionCallable;
import ch.cyberduck.core.threading.DefaultRetryCallable;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.iterate.openstack.swift.Client;
import ch.iterate.openstack.swift.exception.GenericException;
import ch.iterate.openstack.swift.model.StorageObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SwiftLargeUploadWriteFeature
implements MultipartWrite<StorageObject> {
    private static final Logger log = LogManager.getLogger(SwiftLargeUploadWriteFeature.class);
    private final PathContainerService containerService = new DefaultPathContainerService();
    private final SwiftSession session;
    private final SwiftSegmentService segmentService;
    private final SwiftRegionService regionService;

    public SwiftLargeUploadWriteFeature(SwiftSession session) {
        this(session, new SwiftRegionService(session));
    }

    public SwiftLargeUploadWriteFeature(SwiftSession session, SwiftRegionService regionService) {
        this(session, regionService, new SwiftSegmentService(session, regionService));
    }

    public SwiftLargeUploadWriteFeature(SwiftSession session, SwiftRegionService regionService, SwiftSegmentService segmentService) {
        this.session = session;
        this.regionService = regionService;
        this.segmentService = segmentService;
    }

    public HttpResponseOutputStream<StorageObject> write(Path file, TransferStatus status, ConnectionCallback callback) {
        final LargeUploadOutputStream proxy = new LargeUploadOutputStream(file, status);
        return new HttpResponseOutputStream<StorageObject>((OutputStream)new MemorySegementingOutputStream((OutputStream)proxy, Integer.valueOf(new HostPreferences(this.session.getHost()).getInteger("openstack.upload.largeobject.size.minimum"))), (AttributesAdapter)new SwiftAttributesFinderFeature(this.session, this.regionService), status){

            public StorageObject getStatus() {
                return proxy.getResponse();
            }
        };
    }

    public Write.Append append(Path file, TransferStatus status) throws BackgroundException {
        return new Write.Append(false).withStatus(status);
    }

    private final class LargeUploadOutputStream
    extends OutputStream {
        private final List<StorageObject> completed = new ArrayList<StorageObject>();
        private final Path file;
        private final TransferStatus overall;
        private final AtomicBoolean close = new AtomicBoolean();
        private final AtomicReference<IOException> canceled = new AtomicReference();
        private final AtomicReference<StorageObject> response = new AtomicReference();
        private int segmentNumber;

        public LargeUploadOutputStream(Path file, TransferStatus status) {
            this.file = file;
            this.overall = status;
        }

        @Override
        public void write(int value) throws IOException {
            throw new IOException(new UnsupportedOperationException());
        }

        @Override
        public void write(final byte[] content, final int off, final int len) throws IOException {
            try {
                if (null != this.canceled.get()) {
                    throw this.canceled.get();
                }
                this.completed.add((StorageObject)new DefaultRetryCallable(SwiftLargeUploadWriteFeature.this.session.getHost(), (BackgroundExceptionCallable)new BackgroundExceptionCallable<StorageObject>(){

                    public StorageObject call() throws BackgroundException {
                        String checksum;
                        TransferStatus status = new TransferStatus().withLength((long)len);
                        status.setChecksum(SwiftLargeUploadWriteFeature.this.checksum(LargeUploadOutputStream.this.file, status).compute((InputStream)new ByteArrayInputStream(content, off, len), status));
                        Path segment = SwiftLargeUploadWriteFeature.this.segmentService.getSegment(LargeUploadOutputStream.this.file, ++LargeUploadOutputStream.this.segmentNumber);
                        ByteArrayEntity entity = new ByteArrayEntity(content, off, len);
                        HashMap headers = new HashMap();
                        try {
                            checksum = ((Client)SwiftLargeUploadWriteFeature.this.session.getClient()).storeObject(SwiftLargeUploadWriteFeature.this.regionService.lookup(LargeUploadOutputStream.this.file), SwiftLargeUploadWriteFeature.this.containerService.getContainer(segment).getName(), SwiftLargeUploadWriteFeature.this.containerService.getKey(segment), (HttpEntity)entity, headers, status.getChecksum().algorithm == HashAlgorithm.md5 ? status.getChecksum().hash : null);
                        }
                        catch (GenericException e) {
                            LargeUploadOutputStream.this.canceled.set(e);
                            throw new SwiftExceptionMappingService().map("Upload {0} failed", e, LargeUploadOutputStream.this.file);
                        }
                        catch (IOException e) {
                            LargeUploadOutputStream.this.canceled.set(e);
                            throw new DefaultIOExceptionMappingService().map("Upload {0} failed", (Throwable)e, LargeUploadOutputStream.this.file);
                        }
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Saved segment %s with checksum %s", segment, checksum));
                        }
                        StorageObject stored = new StorageObject(SwiftLargeUploadWriteFeature.this.containerService.getKey(segment));
                        stored.setMd5sum(checksum);
                        stored.setSize(Long.valueOf(status.getLength()));
                        return stored;
                    }
                }, (StreamCancelation)this.overall).call());
            }
            catch (BackgroundException e) {
                throw new IOException(e.getMessage(), e);
            }
        }

        @Override
        public void close() throws IOException {
            try {
                if (this.close.get()) {
                    log.warn(String.format("Skip double close of stream %s", this));
                    return;
                }
                if (null != this.canceled.get()) {
                    log.warn(String.format("Skip closing with previous failure %s", this.canceled.get()));
                    return;
                }
                if (this.completed.isEmpty()) {
                    HttpResponseOutputStream<StorageObject> out = new SwiftWriteFeature(SwiftLargeUploadWriteFeature.this.session, SwiftLargeUploadWriteFeature.this.regionService).write(this.file, this.overall.withLength(0L), (ConnectionCallback)new DisabledConnectionCallback());
                    out.close();
                    this.response.set((StorageObject)out.getStatus());
                } else {
                    String manifest = SwiftLargeUploadWriteFeature.this.segmentService.manifest(SwiftLargeUploadWriteFeature.this.containerService.getContainer(this.file).getName(), this.completed);
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Creating SLO manifest %s for %s", manifest, this.file));
                    }
                    String checksum = ((Client)SwiftLargeUploadWriteFeature.this.session.getClient()).createSLOManifestObject(SwiftLargeUploadWriteFeature.this.regionService.lookup(SwiftLargeUploadWriteFeature.this.containerService.getContainer(this.file)), SwiftLargeUploadWriteFeature.this.containerService.getContainer(this.file).getName(), this.overall.getMime(), SwiftLargeUploadWriteFeature.this.containerService.getKey(this.file), manifest, Collections.emptyMap());
                    StorageObject object = new StorageObject(SwiftLargeUploadWriteFeature.this.containerService.getKey(this.file));
                    object.setMd5sum(checksum);
                    Long length = 0L;
                    for (StorageObject part : this.completed) {
                        length = length + part.getSize();
                    }
                    object.setSize(length);
                    this.response.set(object);
                }
            }
            catch (BackgroundException e) {
                throw new IOException(e.getMessage(), e);
            }
            finally {
                this.close.set(true);
            }
        }

        public StorageObject getResponse() {
            return this.response.get();
        }
    }
}

