/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.openstack.SwiftExceptionMappingService;
import ch.cyberduck.core.openstack.SwiftRegionService;
import ch.cyberduck.core.openstack.SwiftSession;
import ch.cyberduck.core.shared.OneTimeSchedulerFeature;
import ch.iterate.openstack.swift.Client;
import ch.iterate.openstack.swift.exception.GenericException;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SwiftContainerSizeLoader
extends OneTimeSchedulerFeature<Long> {
    private static final Logger log = LogManager.getLogger(SwiftContainerSizeLoader.class);
    private final SwiftSession session;
    private final SwiftRegionService regionService;

    public SwiftContainerSizeLoader(SwiftSession session, SwiftRegionService regionService, Path container) {
        super(container);
        this.session = session;
        this.regionService = regionService;
    }

    protected Long operate(PasswordCallback callback, Path container) throws BackgroundException {
        try {
            return ((Client)this.session.getClient()).getContainerInfo(this.regionService.lookup(container), container.getName()).getTotalSize();
        }
        catch (GenericException e) {
            throw new SwiftExceptionMappingService().map(e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }
}

