/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.CancellingListProgressListener;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DefaultPathContainerService;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.date.ISO8601DateParser;
import ch.cyberduck.core.date.InvalidDateException;
import ch.cyberduck.core.date.RFC1123DateFormatter;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ListCanceledException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AttributesAdapter;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.openstack.SwiftExceptionMappingService;
import ch.cyberduck.core.openstack.SwiftObjectListService;
import ch.cyberduck.core.openstack.SwiftRegionService;
import ch.cyberduck.core.openstack.SwiftSession;
import ch.cyberduck.core.openstack.SwiftWriteFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.iterate.openstack.swift.Client;
import ch.iterate.openstack.swift.exception.GenericException;
import ch.iterate.openstack.swift.model.ContainerInfo;
import ch.iterate.openstack.swift.model.ObjectMetadata;
import ch.iterate.openstack.swift.model.Region;
import ch.iterate.openstack.swift.model.StorageObject;
import java.io.IOException;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SwiftAttributesFinderFeature
implements AttributesFinder,
AttributesAdapter<StorageObject> {
    private static final Logger log = LogManager.getLogger(SwiftAttributesFinderFeature.class);
    private final SwiftSession session;
    private final PathContainerService containerService = new DefaultPathContainerService();
    private final RFC1123DateFormatter rfc1123DateFormatter = new RFC1123DateFormatter();
    private final ISO8601DateParser iso8601DateParser = new ISO8601DateParser();
    private final SwiftRegionService regionService;

    public SwiftAttributesFinderFeature(SwiftSession session) {
        this(session, new SwiftRegionService(session));
    }

    public SwiftAttributesFinderFeature(SwiftSession session, SwiftRegionService regionService) {
        this.session = session;
        this.regionService = regionService;
    }

    public PathAttributes find(Path file, ListProgressListener listener) throws BackgroundException {
        if (file.isRoot()) {
            return PathAttributes.EMPTY;
        }
        Region region = this.regionService.lookup(file);
        try {
            ObjectMetadata metadata;
            if (this.containerService.isContainer(file)) {
                ContainerInfo info = ((Client)this.session.getClient()).getContainerInfo(region, this.containerService.getContainer(file).getName());
                PathAttributes attributes = new PathAttributes();
                attributes.setSize(info.getTotalSize());
                attributes.setRegion(info.getRegion().getRegionId());
                return attributes;
            }
            try {
                try {
                    metadata = ((Client)this.session.getClient()).getObjectMetaData(region, this.containerService.getContainer(file).getName(), this.containerService.getKey(file));
                }
                catch (GenericException e) {
                    throw new SwiftExceptionMappingService().map("Failure to read attributes of {0}", e, file);
                }
            }
            catch (NotfoundException e) {
                if (file.isDirectory()) {
                    try {
                        new SwiftObjectListService(this.session).list(file, (ListProgressListener)new CancellingListProgressListener());
                    }
                    catch (ListCanceledException l) {
                        return PathAttributes.EMPTY;
                    }
                    catch (NotfoundException n) {
                        throw e;
                    }
                    return PathAttributes.EMPTY;
                }
                Write.Append append = new SwiftWriteFeature(this.session, this.regionService).append(file, new TransferStatus());
                if (append.append) {
                    return new PathAttributes().withSize(append.size.longValue());
                }
                throw e;
            }
            if (file.isDirectory() && !StringUtils.equals((CharSequence)"application/directory", (CharSequence)metadata.getMimeType())) {
                throw new NotfoundException(String.format("File %s has set MIME type %s but expected %s", file.getAbsolute(), metadata.getMimeType(), "application/directory"));
            }
            if (file.isFile() && StringUtils.equals((CharSequence)"application/directory", (CharSequence)metadata.getMimeType())) {
                throw new NotfoundException(String.format("File %s has set MIME type %s", file.getAbsolute(), metadata.getMimeType()));
            }
            return this.toAttributes(metadata);
        }
        catch (GenericException e) {
            throw new SwiftExceptionMappingService().map("Failure to read attributes of {0}", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Failure to read attributes of {0}", (Throwable)e, file);
        }
    }

    public PathAttributes toAttributes(StorageObject object) {
        PathAttributes attributes = new PathAttributes();
        if (StringUtils.isNotBlank((CharSequence)object.getMd5sum())) {
            attributes.setChecksum(Checksum.parse((String)object.getMd5sum()));
        }
        attributes.setSize(object.getSize().longValue());
        String lastModified = object.getLastModified();
        if (lastModified != null) {
            try {
                attributes.setModificationDate(this.iso8601DateParser.parse(lastModified).getTime());
            }
            catch (InvalidDateException e) {
                log.warn(String.format("%s is not ISO 8601 format %s", lastModified, e.getMessage()));
                try {
                    attributes.setModificationDate(this.rfc1123DateFormatter.parse(lastModified).getTime());
                }
                catch (InvalidDateException f) {
                    log.warn(String.format("%s is not RFC 1123 format %s", lastModified, f.getMessage()));
                }
            }
        }
        return attributes;
    }

    public PathAttributes toAttributes(ObjectMetadata metadata) {
        PathAttributes attributes = new PathAttributes();
        attributes.setSize(Long.parseLong(metadata.getContentLength()));
        String lastModified = metadata.getLastModified();
        try {
            attributes.setModificationDate(new Double(Double.parseDouble(lastModified) * 1000.0).longValue());
        }
        catch (NumberFormatException e) {
            log.warn(String.format("%s is not in UNIX Epoch time stamp format %s", lastModified, e.getMessage()));
        }
        if (StringUtils.isNotBlank((CharSequence)metadata.getETag())) {
            String etag = RegExUtils.removePattern((String)metadata.getETag(), (String)"\"");
            attributes.setETag(etag);
            if (metadata.getMetaData().containsKey("X-Static-Large-Object")) {
                attributes.setChecksum(Checksum.NONE);
            } else {
                attributes.setChecksum(Checksum.parse((String)etag));
            }
        }
        attributes.setMetadata(metadata.getMetaData());
        return attributes;
    }
}

