/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.query;

import java.util.ArrayList;
import java.util.List;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.Tag;
import org.irods.jargon.core.query.IRODSQueryResultRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryResultProcessingUtils {
    private static final Logger log = LoggerFactory.getLogger(QueryResultProcessingUtils.class);

    public static List<IRODSQueryResultRow> translateResponseIntoResultSet(Tag queryResponse, List<String> columnNames, int continuation, int partialStartIndex) throws JargonException {
        if (queryResponse == null) {
            log.info("empty result set from query, returning as an empty result set ( no rows found)");
            return new ArrayList<IRODSQueryResultRow>();
        }
        int rows = queryResponse.getTag("rowCnt").getIntValue();
        log.info("rows returned from iRODS query: {}", (Object)rows);
        ArrayList<IRODSQueryResultRow> resultSet = new ArrayList<IRODSQueryResultRow>(rows);
        int recordCount = partialStartIndex == 0 ? 1 : partialStartIndex + 1;
        boolean lastRecord = continuation == 0;
        log.debug("is this the last record? {}", (Object)lastRecord);
        int attributes = queryResponse.getTag("attriCnt").getIntValue();
        for (int i = 0; i < rows; ++i) {
            ArrayList<String> row = new ArrayList<String>();
            for (int j = 0; j < attributes; ++j) {
                row.add(queryResponse.getTags()[4 + j].getTags()[2 + i].getStringValue());
            }
            resultSet.add(IRODSQueryResultRow.instance(row, columnNames, recordCount++, lastRecord));
        }
        return resultSet;
    }

    public static int getContinuationValue(Tag response) throws JargonException {
        if (response == null) {
            throw new IllegalArgumentException("null response");
        }
        try {
            return response.getTag("continueInx").getIntValue();
        }
        catch (Exception e) {
            throw new JargonException("unable to find continuation value in query result");
        }
    }
}

