/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import java.util.List;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.exception.FileNotFoundException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.pub.CollectionAndDataObjectListAndSearchAO;
import org.irods.jargon.core.pub.CollectionListingUtils;
import org.irods.jargon.core.pub.IRODSGenericAO;
import org.irods.jargon.core.pub.domain.ObjStat;
import org.irods.jargon.core.query.CollectionAndDataObjectListingEntry;
import org.irods.jargon.core.query.PagingAwareCollectionListing;
import org.irods.jargon.core.utils.MiscIRODSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionIteratorAOImpl
extends IRODSGenericAO {
    public static final Logger log = LoggerFactory.getLogger(CollectionIteratorAOImpl.class);
    private final CollectionAndDataObjectListAndSearchAO collectionAndDataObjectListAndSearchAO = this.getIRODSAccessObjectFactory().getCollectionAndDataObjectListAndSearchAO(this.getIRODSAccount());
    private final CollectionListingUtils collectionListingUtils = new CollectionListingUtils(this.collectionAndDataObjectListAndSearchAO);

    protected CollectionIteratorAOImpl(IRODSSession irodsSession, IRODSAccount irodsAccount) throws JargonException {
        super(irodsSession, irodsAccount);
    }

    public PagingAwareCollectionListing retrivePagingAwareCollectionListing(String absolutePathToParent) throws FileNotFoundException, JargonException {
        log.info("retrivePagingAwareCollectionListing()");
        if (absolutePathToParent == null || absolutePathToParent.isEmpty()) {
            throw new IllegalArgumentException("absolutePathToParent is null or empty");
        }
        log.info("absolutePath:{}", (Object)absolutePathToParent);
        PagingAwareCollectionListing pagingAwareCollectionListing = new PagingAwareCollectionListing();
        pagingAwareCollectionListing.setPageSizeUtilized(this.getJargonProperties().getMaxFilesAndDirsQueryMax());
        List<CollectionAndDataObjectListingEntry> entries = null;
        ObjStat objStat = null;
        try {
            objStat = this.collectionAndDataObjectListAndSearchAO.retrieveObjectStatForPath(absolutePathToParent);
        }
        catch (FileNotFoundException fnf) {
            log.info("didnt find an objStat for the path, account for cases where there are strict acls and give Jargon a chance to drill down to a place where the user has permissions");
            entries = this.collectionListingUtils.handleNoListingUnderRootOrHomeByLookingForPublicAndHome(absolutePathToParent);
            pagingAwareCollectionListing.setCollectionAndDataObjectListingEntries(entries);
            pagingAwareCollectionListing.setCollectionsComplete(true);
            pagingAwareCollectionListing.setCollectionsCount(entries.size());
            return pagingAwareCollectionListing;
        }
        MiscIRODSUtils.evaluateSpecCollSupport(objStat);
        List<CollectionAndDataObjectListingEntry> queriedEntries = this.collectionListingUtils.listCollectionsUnderPath(objStat, 0);
        if (queriedEntries.isEmpty()) {
            log.info("no child collections");
            pagingAwareCollectionListing.setCollectionsComplete(true);
            pagingAwareCollectionListing.setCollectionsCount(0);
            pagingAwareCollectionListing.setCollectionsOffset(0);
        } else {
            log.info("adding child collections");
            pagingAwareCollectionListing.setCollectionsComplete(queriedEntries.get(queriedEntries.size() - 1).isLastResult());
            pagingAwareCollectionListing.setCollectionsCount(queriedEntries.get(queriedEntries.size() - 1).getCount());
            pagingAwareCollectionListing.setCollectionsTotalRecords(queriedEntries.get(0).getTotalRecords());
            pagingAwareCollectionListing.getCollectionAndDataObjectListingEntries().addAll(queriedEntries);
        }
        queriedEntries = this.collectionListingUtils.listDataObjectsUnderPath(objStat, 0);
        if (queriedEntries.isEmpty()) {
            log.info("no child data objects");
            pagingAwareCollectionListing.setDataObjectsComplete(true);
            pagingAwareCollectionListing.setDataObjectsCount(0);
            pagingAwareCollectionListing.setDataObjectsOffset(0);
        } else {
            log.info("adding child data objects");
            pagingAwareCollectionListing.setDataObjectsComplete(queriedEntries.get(queriedEntries.size() - 1).isLastResult());
            pagingAwareCollectionListing.setDataObjectsCount(queriedEntries.get(queriedEntries.size() - 1).getCount());
            pagingAwareCollectionListing.setDataObjectsTotalRecords(queriedEntries.get(0).getTotalRecords());
            pagingAwareCollectionListing.getCollectionAndDataObjectListingEntries().addAll(queriedEntries);
        }
        log.info("pagingAwareCollectionListing:{}", (Object)pagingAwareCollectionListing);
        return pagingAwareCollectionListing;
    }
}

