/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.impl;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.cryptomator.CryptoFilename;
import ch.cyberduck.core.cryptomator.CryptoInvalidFilenameException;
import ch.cyberduck.core.exception.BackgroundException;

public class CryptoFilenameV7Provider
implements CryptoFilename {
    public static final int NAME_SHORTENING_THRESHOLD = 220;

    @Override
    public boolean isDeflated(String filename) {
        return false;
    }

    @Override
    public boolean isValid(String filename) {
        return this.isBelowThreshold(filename);
    }

    @Override
    public String inflate(Session<?> session, String shortName) throws BackgroundException {
        return shortName;
    }

    @Override
    public String deflate(Session<?> session, String filename) throws BackgroundException {
        if (this.isBelowThreshold(filename)) {
            return filename;
        }
        throw new CryptoInvalidFilenameException(String.format("Filename length %d exceeds maximum length %d", filename.length(), 220));
    }

    @Override
    public Path resolve(String filename) {
        return null;
    }

    @Override
    public void invalidate(String filename) {
    }

    @Override
    public void destroy() {
    }

    private boolean isBelowThreshold(String filename) {
        return filename.length() <= 220;
    }
}

