/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.impl;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.RandomStringService;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.UUIDRandomStringService;
import ch.cyberduck.core.cryptomator.ContentReader;
import ch.cyberduck.core.cryptomator.CryptoVault;
import ch.cyberduck.core.cryptomator.impl.CryptoDirectoryV6Provider;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import com.google.common.io.BaseEncoding;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CryptoDirectoryV7Provider
extends CryptoDirectoryV6Provider {
    private static final Logger log = LogManager.getLogger(CryptoDirectoryV7Provider.class);
    public static final String EXTENSION_REGULAR = ".c9r";
    public static final String FILENAME_DIRECTORYID = "dir";
    public static final String DIRECTORY_METADATAFILE = String.format("%s%s", "dir", ".c9r");
    private final CryptoVault cryptomator;
    private final RandomStringService random = new UUIDRandomStringService();

    public CryptoDirectoryV7Provider(Path vault, CryptoVault cryptomator) {
        super(vault, cryptomator);
        this.cryptomator = cryptomator;
    }

    @Override
    public String toEncrypted(Session<?> session, String directoryId, String filename, EnumSet<AbstractPath.Type> type) throws BackgroundException {
        String ciphertextName = this.cryptomator.getFileNameCryptor().encryptFilename(BaseEncoding.base64Url(), filename, directoryId.getBytes(StandardCharsets.UTF_8)) + EXTENSION_REGULAR;
        if (log.isDebugEnabled()) {
            log.debug(String.format("Encrypted filename %s to %s", filename, ciphertextName));
        }
        return this.cryptomator.getFilenameProvider().deflate(session, ciphertextName);
    }

    @Override
    protected String load(Session<?> session, Path directory) throws BackgroundException {
        Path parent = this.toEncrypted(session, directory.getParent().attributes().getDirectoryId(), directory.getParent());
        String cleartextName = directory.getName();
        String ciphertextName = this.toEncrypted(session, parent.attributes().getDirectoryId(), cleartextName, EnumSet.of(AbstractPath.Type.directory));
        Path metadataParent = new Path(parent, ciphertextName, EnumSet.of(AbstractPath.Type.directory));
        try {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Read directory ID for folder %s from %s", directory, ciphertextName));
            }
            Path metadataFile = new Path(metadataParent, DIRECTORY_METADATAFILE, EnumSet.of(AbstractPath.Type.file, AbstractPath.Type.encrypted));
            return new ContentReader(session).read(metadataFile);
        }
        catch (NotfoundException e) {
            log.warn(String.format("Missing directory ID for folder %s", directory));
            return this.random.random();
        }
    }
}

