/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.impl;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.CacheReference;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.RandomStringService;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SimplePathPredicate;
import ch.cyberduck.core.UUIDRandomStringService;
import ch.cyberduck.core.cache.LRUCache;
import ch.cyberduck.core.cryptomator.ContentReader;
import ch.cyberduck.core.cryptomator.CryptoDirectory;
import ch.cyberduck.core.cryptomator.CryptoVault;
import ch.cyberduck.core.cryptomator.CryptorCache;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CryptoDirectoryV6Provider
implements CryptoDirectory {
    private static final Logger log = LogManager.getLogger(CryptoDirectoryV6Provider.class);
    private static final String DATA_DIR_NAME = "d";
    private static final String ROOT_DIR_ID = "";
    private final Path dataRoot;
    private final Path home;
    private final CryptoVault cryptomator;
    private final RandomStringService random = new UUIDRandomStringService();
    private final Lock lock = new ReentrantLock();
    private final LRUCache<CacheReference<Path>, String> cache = LRUCache.build((long)PreferencesFactory.get().getInteger("cryptomator.cache.size"));

    public CryptoDirectoryV6Provider(Path vault, CryptoVault cryptomator) {
        this.home = vault;
        this.dataRoot = new Path(vault, DATA_DIR_NAME, vault.getType());
        this.cryptomator = cryptomator;
    }

    @Override
    public String toEncrypted(Session<?> session, String directoryId, String filename, EnumSet<AbstractPath.Type> type) throws BackgroundException {
        String prefix = type.contains(AbstractPath.Type.directory) ? "0" : ROOT_DIR_ID;
        String ciphertextName = prefix + this.cryptomator.getFileNameCryptor().encryptFilename(CryptorCache.BASE32, filename, directoryId.getBytes(StandardCharsets.UTF_8));
        if (log.isDebugEnabled()) {
            log.debug(String.format("Encrypted filename %s to %s", filename, ciphertextName));
        }
        return this.cryptomator.getFilenameProvider().deflate(session, ciphertextName);
    }

    @Override
    public Path toEncrypted(Session<?> session, String directoryId, Path directory) throws BackgroundException {
        if (!directory.isDirectory()) {
            throw new NotfoundException(directory.getAbsolute());
        }
        if (new SimplePathPredicate(directory).test(this.home) || directory.isChild(this.home)) {
            PathAttributes attributes = new PathAttributes(directory.attributes());
            attributes.withVersionId(null);
            attributes.withFileId(null);
            String id = this.toDirectoryId(session, directory, directoryId);
            if (log.isDebugEnabled()) {
                log.debug(String.format("Use directory ID '%s' for folder %s", id, directory));
            }
            attributes.setDirectoryId(id);
            attributes.setDecrypted(directory);
            String directoryIdHash = this.cryptomator.getFileNameCryptor().hashDirectoryId(id);
            Path intermediate = new Path(this.dataRoot, directoryIdHash.substring(0, 2), this.dataRoot.getType());
            EnumSet<AbstractPath.Type> type = EnumSet.copyOf(directory.getType());
            type.add(AbstractPath.Type.encrypted);
            type.remove(AbstractPath.Type.decrypted);
            return new Path(intermediate, directoryIdHash.substring(2), type, attributes);
        }
        throw new NotfoundException(directory.getAbsolute());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toDirectoryId(Session<?> session, Path directory, String directoryId) throws BackgroundException {
        if (new SimplePathPredicate(this.home).test(directory)) {
            return ROOT_DIR_ID;
        }
        if (StringUtils.isBlank((CharSequence)directoryId)) {
            if (this.cache.contains((Object)new SimplePathPredicate(directory))) {
                return (String)this.cache.get((Object)new SimplePathPredicate(directory));
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Acquire lock for %s", directory));
                }
                this.lock.lock();
                String id = this.load(session, directory);
                this.cache.put((Object)new SimplePathPredicate(directory), (Object)id);
                String string = id;
                return string;
            }
            finally {
                this.lock.unlock();
            }
        }
        if (!this.cache.contains((Object)new SimplePathPredicate(directory))) {
            this.cache.put((Object)new SimplePathPredicate(directory), (Object)directoryId);
        } else {
            String existing = (String)this.cache.get((Object)new SimplePathPredicate(directory));
            if (!existing.equals(directoryId)) {
                log.warn(String.format("Do not override already cached id %s with %s", existing, directoryId));
            }
        }
        return (String)this.cache.get((Object)new SimplePathPredicate(directory));
    }

    protected String load(Session<?> session, Path directory) throws BackgroundException {
        Path parent = this.toEncrypted(session, directory.getParent().attributes().getDirectoryId(), directory.getParent());
        String cleartextName = directory.getName();
        String ciphertextName = this.toEncrypted(session, parent.attributes().getDirectoryId(), cleartextName, EnumSet.of(AbstractPath.Type.directory));
        try {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Read directory ID for folder %s from %s", directory, ciphertextName));
            }
            Path metadataFile = new Path(parent, ciphertextName, EnumSet.of(AbstractPath.Type.file, AbstractPath.Type.encrypted));
            return new ContentReader(session).read(metadataFile);
        }
        catch (NotfoundException e) {
            log.warn(String.format("Missing directory ID for folder %s", directory));
            return this.random.random();
        }
    }

    @Override
    public void delete(Path directory) {
        this.cache.remove((Object)new SimplePathPredicate(directory));
    }

    @Override
    public void destroy() {
        this.cache.clear();
    }
}

