/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.features;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.cryptomator.CryptoInvalidFilesizeException;
import ch.cyberduck.core.cryptomator.CryptoOutputStream;
import ch.cyberduck.core.cryptomator.CryptoVault;
import ch.cyberduck.core.cryptomator.features.CryptoChecksumCompute;
import ch.cyberduck.core.cryptomator.random.RotatingNonceGenerator;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.random.NonceGenerator;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CryptoWriteFeature<Reply>
implements Write<Reply> {
    private static final Logger log = LogManager.getLogger(CryptoWriteFeature.class);
    private final Session<?> session;
    private final Write<Reply> proxy;
    private final CryptoVault vault;

    public CryptoWriteFeature(Session<?> session, Write<Reply> proxy, CryptoVault vault) {
        this.session = session;
        this.proxy = proxy;
        this.vault = vault;
    }

    public StatusOutputStream<Reply> write(Path file, final TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            if (null == status.getNonces()) {
                status.setNonces((NonceGenerator)new RotatingNonceGenerator(this.vault.numberOfChunks(status.getLength())));
            }
            final StatusOutputStream cleartext = this.proxy.write(this.vault.encrypt(this.session, file), new TransferStatus(status){

                public void setResponse(PathAttributes attributes) {
                    try {
                        status.setResponse(attributes.withSize(CryptoWriteFeature.this.vault.toCleartextSize(0L, attributes.getSize())));
                    }
                    catch (CryptoInvalidFilesizeException e) {
                        log.warn(String.format("Failure %s translating file size from response %s", new Object[]{e, attributes}));
                    }
                }
            }.withLength(this.vault.toCiphertextSize(status.getOffset(), status.getLength())).withOffset(0L == status.getOffset() ? 0L : this.vault.toCiphertextSize(0L, status.getOffset())).withMime(null), callback);
            if (status.getOffset() == 0L) {
                cleartext.write(status.getHeader().array());
            }
            return new StatusOutputStream<Reply>((OutputStream)((Object)new CryptoOutputStream((OutputStream)cleartext, this.vault.getFileContentCryptor(), this.vault.getFileHeaderCryptor().decryptHeader(status.getHeader()), status.getNonces(), this.vault.numberOfChunks(status.getOffset())))){

                public Reply getStatus() throws BackgroundException {
                    return cleartext.getStatus();
                }
            };
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public Write.Append append(Path file, TransferStatus status) throws BackgroundException {
        return new Write.Append(false).withStatus(status);
    }

    public boolean random() {
        return this.proxy.random();
    }

    public boolean timestamp() {
        return this.proxy.timestamp();
    }

    public ChecksumCompute checksum(Path file, TransferStatus status) {
        return new CryptoChecksumCompute(this.proxy.checksum(file, status), this.vault);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoWriteFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

