/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.features;

import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.features.VersionIdProvider;

public class CryptoVersionIdProvider
implements VersionIdProvider {
    private final Session<?> session;
    private final VersionIdProvider delegate;
    private final Vault vault;

    public CryptoVersionIdProvider(Session<?> session, VersionIdProvider delegate, Vault vault) {
        this.session = session;
        this.delegate = delegate;
        this.vault = vault;
    }

    public String getVersionId(Path file, ListProgressListener listener) throws BackgroundException {
        return this.delegate.getVersionId(this.vault.encrypt(this.session, file), listener);
    }

    public void clear() {
        this.delegate.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoVersionIdProvider{");
        sb.append("delegate=").append(this.delegate);
        sb.append('}');
        return sb.toString();
    }
}

