/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.features;

import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.DescriptiveUrlBag;
import ch.cyberduck.core.HostUrlProvider;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.vault.DecryptingListProgressListener;
import java.net.URI;
import java.text.MessageFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CryptoUrlProvider
implements UrlProvider {
    private static final Logger log = LogManager.getLogger(DecryptingListProgressListener.class);
    private final Session<?> session;
    private final UrlProvider delegate;
    private final Vault vault;

    public CryptoUrlProvider(Session<?> session, UrlProvider delegate, Vault vault) {
        this.session = session;
        this.delegate = delegate;
        this.vault = vault;
    }

    public DescriptiveUrlBag toUrl(Path file) {
        try {
            DescriptiveUrlBag set = this.delegate.toUrl(file);
            Path encrypt = this.vault.encrypt(this.session, file);
            set.add(new DescriptiveUrl(URI.create(String.format("%s%s", new HostUrlProvider().withUsername(false).get(this.session.getHost()), URIEncoder.encode((String)encrypt.getAbsolute()))), DescriptiveUrl.Type.encrypted, MessageFormat.format(LocaleFactory.localizedString((String)"{0} URL"), LocaleFactory.localizedString((String)"Encrypted", (String)"Cryptomator"))));
            return set;
        }
        catch (BackgroundException e) {
            log.warn(String.format("Failure encrypting filename. %s", e.getMessage()));
            return DescriptiveUrlBag.empty();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoUrlProvider{");
        sb.append("delegate=").append(this.delegate);
        sb.append('}');
        return sb.toString();
    }
}

