/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.features;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.cryptomator.CryptoVault;
import ch.cyberduck.core.cryptomator.features.CryptoWriteFeature;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.transfer.TransferStatus;

public class CryptoUploadFeature<Reply>
implements Upload<Reply> {
    private final Session<?> session;
    private final Upload<Reply> proxy;
    private final CryptoVault vault;

    public CryptoUploadFeature(Session<?> session, Upload<Reply> delegate, Write<Reply> writer, CryptoVault vault) {
        this.session = session;
        this.proxy = delegate.withWriter(new CryptoWriteFeature<Reply>(session, writer, vault));
        this.vault = vault;
    }

    public Reply upload(Path file, Local local, BandwidthThrottle throttle, StreamListener listener, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        return (Reply)this.proxy.upload(this.vault.encrypt(this.session, file), local, throttle, listener, status, callback);
    }

    public Write.Append append(Path file, TransferStatus status) throws BackgroundException {
        return this.proxy.append(this.vault.encrypt(this.session, file), status);
    }

    public Upload<Reply> withWriter(Write<Reply> writer) {
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoUploadFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

