/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.features;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.cryptomator.CryptoVault;
import ch.cyberduck.core.cryptomator.features.CryptoWriteFeature;
import ch.cyberduck.core.cryptomator.random.RandomNonceGenerator;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.random.NonceGenerator;
import ch.cyberduck.core.transfer.TransferStatus;
import org.cryptomator.cryptolib.api.FileHeader;

public class CryptoTouchFeature<Reply>
implements Touch<Reply> {
    private final Session<?> session;
    private final Touch<Reply> proxy;
    private final CryptoVault vault;

    public CryptoTouchFeature(Session<?> session, Touch<Reply> proxy, Write<Reply> writer, CryptoVault cryptomator) {
        this.session = session;
        this.proxy = proxy.withWriter(new CryptoWriteFeature<Reply>(session, writer, cryptomator));
        this.vault = cryptomator;
    }

    public Path touch(Path file, final TransferStatus status) throws BackgroundException {
        FileHeader header = this.vault.getFileHeaderCryptor().create();
        status.setHeader(this.vault.getFileHeaderCryptor().encryptHeader(header));
        status.setNonces((NonceGenerator)new RandomNonceGenerator());
        Path target = this.proxy.touch(this.vault.encrypt(this.session, file), new TransferStatus(status){

            public void setResponse(PathAttributes attributes) {
                status.setResponse(attributes);
                super.setResponse(new PathAttributes(attributes).withSize(CryptoTouchFeature.this.vault.toCiphertextSize(0L, attributes.getSize())));
            }
        });
        Path decrypt = this.vault.decrypt(this.session, target);
        decrypt.attributes().withVersionId(target.attributes().getVersionId());
        return decrypt;
    }

    public boolean isSupported(Path workdir, String filename) {
        return this.proxy.isSupported(workdir, "") && this.vault.getFilenameProvider().isValid(filename);
    }

    public CryptoTouchFeature<Reply> withWriter(Write<Reply> writer) {
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoTouchFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

