/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.features;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.cryptomator.CryptoVault;
import ch.cyberduck.core.cryptomator.impl.CryptoDirectoryV7Provider;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.EnumSet;

public class CryptoMoveV7Feature
implements Move {
    private final Session<?> session;
    private final Move proxy;
    private final CryptoVault vault;

    public CryptoMoveV7Feature(Session<?> session, Move delegate, CryptoVault cryptomator) {
        this.session = session;
        this.proxy = delegate;
        this.vault = cryptomator;
    }

    public Path move(Path file, Path renamed, TransferStatus status, Delete.Callback callback, ConnectionCallback connectionCallback) throws BackgroundException {
        Path sourceEncrypted = this.vault.encrypt(this.session, file, file.isDirectory());
        Path targetEncrypted = this.vault.encrypt(this.session, renamed, file.isDirectory());
        Path target = this.proxy.move(sourceEncrypted, targetEncrypted, status, callback, connectionCallback);
        if (file.isDirectory()) {
            if (!this.proxy.isRecursive(file, renamed)) {
                this.proxy.move(new Path(sourceEncrypted, CryptoDirectoryV7Provider.DIRECTORY_METADATAFILE, EnumSet.of(AbstractPath.Type.file)), new Path(targetEncrypted, CryptoDirectoryV7Provider.DIRECTORY_METADATAFILE, EnumSet.of(AbstractPath.Type.file)), new TransferStatus(status), callback, connectionCallback);
            }
            this.vault.getDirectoryProvider().delete(file);
        }
        if (this.vault.contains(target)) {
            return this.vault.decrypt(this.session, target);
        }
        return target;
    }

    public boolean isRecursive(Path source, Path target) {
        return true;
    }

    public boolean isSupported(Path source, Path target) {
        return this.proxy.isSupported(source, target) && this.vault.getFilenameProvider().isValid(target.getName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoMoveFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

