/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.features;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Location;
import ch.cyberduck.core.features.Vault;
import java.util.Set;

public class CryptoLocationFeature
implements Location {
    private final Session<?> session;
    private final Location delegate;
    private final Vault vault;

    public CryptoLocationFeature(Session<?> session, Location delegate, Vault vault) {
        this.session = session;
        this.delegate = delegate;
        this.vault = vault;
    }

    public Location.Name getDefault() {
        return this.delegate.getDefault();
    }

    public Set<Location.Name> getLocations() {
        return this.delegate.getLocations();
    }

    public Location.Name getLocation(Path file) throws BackgroundException {
        return this.delegate.getLocation(this.vault.encrypt(this.session, file));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoLocationFeature{");
        sb.append("delegate=").append(this.delegate);
        sb.append('}');
        return sb.toString();
    }
}

