/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.features;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.vault.DecryptingListProgressListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CryptoListService
implements ListService {
    private static final Logger log = LogManager.getLogger(CryptoListService.class);
    private final Session<?> session;
    private final ListService delegate;
    private final Vault vault;

    public CryptoListService(Session<?> session, ListService delegate, Vault vault) {
        this.session = session;
        this.delegate = delegate;
        this.vault = vault;
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        Path target = this.vault.encrypt(this.session, directory);
        try {
            return this.delegate.list(target, (ListProgressListener)new DecryptingListProgressListener(this.session, this.vault, listener));
        }
        catch (NotfoundException e) {
            log.error(String.format("Failure %s listing directory %s at %s", new Object[]{e, directory, target}));
            return new AttributedList();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoListService{");
        sb.append("delegate=").append(this.delegate);
        sb.append('}');
        return sb.toString();
    }
}

