/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.features;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.cryptomator.impl.CryptoDirectoryV7Provider;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Vault;
import java.util.EnumSet;

public class CryptoFindV7Feature
implements Find {
    private final Session<?> session;
    private final Find delegate;
    private final Vault vault;

    public CryptoFindV7Feature(Session<?> session, Find delegate, Vault vault) {
        this.session = session;
        this.delegate = delegate;
        this.vault = vault;
    }

    public boolean find(Path file, ListProgressListener listener) throws BackgroundException {
        Path encrypted = this.vault.encrypt(this.session, file, true);
        if (file.isDirectory()) {
            return this.delegate.find(new Path(encrypted, CryptoDirectoryV7Provider.DIRECTORY_METADATAFILE, EnumSet.of(AbstractPath.Type.file)), listener);
        }
        return this.delegate.find(encrypted, listener);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoFindFeature{");
        sb.append("delegate=").append(this.delegate);
        sb.append('}');
        return sb.toString();
    }
}

