/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.features;

import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.FileIdProvider;
import ch.cyberduck.core.features.Vault;

public class CryptoFileIdProvider
implements FileIdProvider {
    private final Session<?> session;
    private final FileIdProvider delegate;
    private final Vault vault;

    public CryptoFileIdProvider(Session<?> session, FileIdProvider delegate, Vault vault) {
        this.session = session;
        this.delegate = delegate;
        this.vault = vault;
    }

    public String getFileId(Path file, ListProgressListener listener) throws BackgroundException {
        return this.delegate.getFileId(this.vault.encrypt(this.session, file, true), listener);
    }

    public void clear() {
        this.delegate.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoFileIdProvider{");
        sb.append("delegate=").append(this.delegate);
        sb.append('}');
        return sb.toString();
    }
}

