/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.features;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.RandomStringService;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.UUIDRandomStringService;
import ch.cyberduck.core.cryptomator.ContentWriter;
import ch.cyberduck.core.cryptomator.CryptoVault;
import ch.cyberduck.core.cryptomator.features.CryptoWriteFeature;
import ch.cyberduck.core.cryptomator.impl.CryptoDirectoryV7Provider;
import ch.cyberduck.core.cryptomator.random.RandomNonceGenerator;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.random.NonceGenerator;
import ch.cyberduck.core.transfer.TransferStatus;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cryptomator.cryptolib.api.FileHeader;

public class CryptoDirectoryV7Feature<Reply>
implements Directory<Reply> {
    private static final Logger log = LogManager.getLogger(CryptoDirectoryV7Feature.class);
    private final Session<?> session;
    private final Write<Reply> writer;
    private final Find find;
    private final Directory<Reply> delegate;
    private final CryptoVault vault;
    private final RandomStringService random = new UUIDRandomStringService();

    public CryptoDirectoryV7Feature(Session<?> session, Directory<Reply> delegate, Write<Reply> writer, Find find, CryptoVault cryptomator) {
        this.session = session;
        this.writer = writer;
        this.find = find;
        this.delegate = delegate;
        this.vault = cryptomator;
    }

    public Path mkdir(Path folder, TransferStatus status) throws BackgroundException {
        Path encrypt = this.vault.encrypt(this.session, folder, this.random.random(), false);
        String directoryId = encrypt.attributes().getDirectoryId();
        Path directoryMetadataFolder = this.vault.encrypt(this.session, folder, true);
        Path directoryMetadataFile = new Path(((Directory)this.session._getFeature(Directory.class)).mkdir(directoryMetadataFolder, new TransferStatus().withRegion(status.getRegion())), CryptoDirectoryV7Provider.DIRECTORY_METADATAFILE, EnumSet.of(AbstractPath.Type.file));
        if (log.isDebugEnabled()) {
            log.debug(String.format("Write metadata %s for folder %s", directoryMetadataFile, folder));
        }
        new ContentWriter(this.session).write(directoryMetadataFile, directoryId.getBytes(StandardCharsets.UTF_8));
        Path intermediate = encrypt.getParent();
        if (!this.find.find(intermediate)) {
            this.delegate.mkdir(intermediate, new TransferStatus().withRegion(status.getRegion()));
        }
        FileHeader header = this.vault.getFileHeaderCryptor().create();
        status.setHeader(this.vault.getFileHeaderCryptor().encryptHeader(header));
        status.setNonces((NonceGenerator)new RandomNonceGenerator());
        Path target = this.delegate.withWriter(new CryptoWriteFeature<Reply>(this.session, this.writer, this.vault)).mkdir(encrypt, status);
        target.attributes().setDirectoryId(directoryId);
        target.attributes().setDecrypted(folder);
        Path decrypt = this.vault.decrypt(this.session, this.vault.encrypt(this.session, target, true));
        decrypt.attributes().setFileId(directoryMetadataFolder.attributes().getFileId());
        decrypt.attributes().setVersionId(directoryMetadataFolder.attributes().getVersionId());
        return decrypt;
    }

    public boolean isSupported(Path workdir, String name) {
        return this.delegate.isSupported(workdir, name);
    }

    public CryptoDirectoryV7Feature<Reply> withWriter(Write<Reply> writer) {
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoDirectoryFeature{");
        sb.append("proxy=").append(this.delegate);
        sb.append('}');
        return sb.toString();
    }
}

