/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.features;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.cryptomator.CryptoFilename;
import ch.cyberduck.core.cryptomator.CryptoVault;
import ch.cyberduck.core.cryptomator.impl.CryptoDirectoryV7Provider;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Trash;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CryptoDeleteV7Feature
implements Delete,
Trash {
    private static final Logger log = LogManager.getLogger(CryptoDeleteV7Feature.class);
    private final Session<?> session;
    private final Delete proxy;
    private final CryptoVault vault;
    private final CryptoFilename filenameProvider;

    public CryptoDeleteV7Feature(Session<?> session, Delete proxy, CryptoVault vault) {
        this.session = session;
        this.proxy = proxy;
        this.vault = vault;
        this.filenameProvider = vault.getFilenameProvider();
    }

    public void delete(Map<Path, TransferStatus> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        for (Path f : files.keySet()) {
            ArrayList<Path> metadataFiles = new ArrayList<Path>();
            if (!f.equals((Object)this.vault.getHome())) {
                Path metadataFile;
                Path encrypt = this.vault.encrypt(this.session, f);
                try {
                    this.proxy.delete(Collections.singletonList(encrypt), prompt, callback);
                }
                catch (NotfoundException e) {
                    if (f.isDirectory()) {
                        log.error(String.format("Failure %s deleting directory %s", new Object[]{e, encrypt}));
                    }
                    throw e;
                }
                Path metadata = this.vault.encrypt(this.session, f, true);
                if (f.isDirectory()) {
                    metadataFile = new Path(metadata, CryptoDirectoryV7Provider.DIRECTORY_METADATAFILE, EnumSet.of(AbstractPath.Type.file));
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Add metadata file %s", metadataFile));
                    }
                    metadataFiles.add(metadataFile);
                    metadataFiles.add(metadata);
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Add metadata folder %s", metadata));
                    }
                    this.vault.getDirectoryProvider().delete(f);
                }
                if (this.filenameProvider.isDeflated(metadata.getName())) {
                    this.filenameProvider.invalidate(this.filenameProvider.inflate(this.session, metadata.getName()));
                    metadataFile = this.filenameProvider.resolve(metadata.getName());
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Add metadata file %s", metadata));
                    }
                    metadataFiles.add(metadataFile);
                }
            }
            if (metadataFiles.isEmpty()) continue;
            try {
                this.proxy.delete(metadataFiles, prompt, callback);
            }
            catch (NotfoundException e) {
                log.error(String.format("Failure %s deleting file %s", new Object[]{e, metadataFiles}));
            }
        }
        for (Path f : files.keySet()) {
            if (!f.equals((Object)this.vault.getHome())) continue;
            log.warn(String.format("Recursively delete vault %s", f));
            ArrayList<Path> metadata = new ArrayList<Path>();
            if (!this.proxy.isRecursive()) {
                Path dataRoot;
                Find find = (Find)this.session._getFeature(Find.class);
                if (find.find(dataRoot = new Path(f, "d", f.getType()))) {
                    for (Path d : ((ListService)this.session._getFeature(ListService.class)).list(dataRoot, (ListProgressListener)new DisabledListProgressListener()).toList()) {
                        metadata.addAll(((ListService)this.session._getFeature(ListService.class)).list(d, (ListProgressListener)new DisabledListProgressListener()).toList());
                        metadata.add(d);
                    }
                    metadata.add(dataRoot);
                }
                metadata.add(this.vault.getMasterkey());
                if (find.find(this.vault.getConfig())) {
                    metadata.add(this.vault.getConfig());
                }
            }
            metadata.add(f);
            this.proxy.delete(metadata, prompt, callback);
        }
    }

    public boolean isSupported(Path file) {
        return this.proxy.isSupported(file);
    }

    public boolean isRecursive() {
        return this.proxy.isRecursive();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoDeleteFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

