/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.features;

import ch.cyberduck.core.cryptomator.CryptoOutputStream;
import ch.cyberduck.core.cryptomator.CryptoVault;
import ch.cyberduck.core.cryptomator.random.RotatingNonceGenerator;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ChecksumException;
import ch.cyberduck.core.io.AbstractChecksumCompute;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.StreamCancelation;
import ch.cyberduck.core.io.StreamCopier;
import ch.cyberduck.core.io.StreamProgress;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.random.NonceGenerator;
import ch.cyberduck.core.threading.ThreadPool;
import ch.cyberduck.core.threading.ThreadPoolFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.worker.DefaultExceptionMappingService;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.io.input.NullInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cryptomator.cryptolib.api.FileHeader;

public class CryptoChecksumCompute
extends AbstractChecksumCompute {
    private static final Logger log = LogManager.getLogger(CryptoChecksumCompute.class);
    private final CryptoVault cryptomator;
    private final ChecksumCompute delegate;

    public CryptoChecksumCompute(ChecksumCompute delegate, CryptoVault vault) {
        this.cryptomator = vault;
        this.delegate = delegate;
    }

    public Checksum compute(InputStream in, TransferStatus status) throws BackgroundException {
        if (Checksum.NONE == this.delegate.compute((InputStream)new NullInputStream(0L), new TransferStatus())) {
            return Checksum.NONE;
        }
        if (null == status.getHeader()) {
            FileHeader header = this.cryptomator.getFileHeaderCryptor().create();
            status.setHeader(this.cryptomator.getFileHeaderCryptor().encryptHeader(header));
        }
        if (null == status.getNonces()) {
            status.setNonces((NonceGenerator)new RotatingNonceGenerator(this.cryptomator.numberOfChunks(status.getLength())));
        }
        return this.compute(this.normalize(in, status), (StreamCancelation)status, status.getOffset(), status.getLength(), status.getHeader(), status.getNonces());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    protected Checksum compute(final InputStream in, final StreamCancelation cancel, final long offset, long length, final ByteBuffer header, NonceGenerator nonces) throws ChecksumException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Calculate checksum with header %s", header));
        }
        try {
            final PipedOutputStream source = new PipedOutputStream();
            final CryptoOutputStream out = new CryptoOutputStream(source, this.cryptomator.getFileContentCryptor(), this.cryptomator.getFileHeaderCryptor().decryptHeader(header), nonces, this.cryptomator.numberOfChunks(offset));
            PipedInputStream sink = new PipedInputStream(source, PreferencesFactory.get().getInteger("connection.chunksize"));
            ThreadPool pool = ThreadPoolFactory.get((String)"checksum", (int)1);
            try {
                Checksum checksum;
                Future execute = pool.execute((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        if (offset == 0L) {
                            source.write(header.array());
                        }
                        new StreamCopier(cancel, StreamProgress.noop).transfer(in, (OutputStream)((Object)out));
                        return null;
                    }
                });
                try {
                    checksum = this.delegate.compute((InputStream)sink, new TransferStatus().withLength(this.cryptomator.toCiphertextSize(offset, length)));
                }
                catch (Throwable throwable) {
                    try {
                        Uninterruptibles.getUninterruptibly((Future)execute);
                    }
                    catch (ExecutionException e) {
                        Throwables.throwIfInstanceOf((Throwable)Throwables.getRootCause((Throwable)e), BackgroundException.class);
                        throw new DefaultExceptionMappingService().map(Throwables.getRootCause((Throwable)e));
                    }
                    throw throwable;
                }
                try {
                    Uninterruptibles.getUninterruptibly((Future)execute);
                }
                catch (ExecutionException e) {
                    Throwables.throwIfInstanceOf((Throwable)Throwables.getRootCause((Throwable)e), BackgroundException.class);
                    throw new DefaultExceptionMappingService().map(Throwables.getRootCause((Throwable)e));
                }
                return checksum;
            }
            finally {
                pool.shutdown(true);
            }
        }
        catch (ChecksumException e) {
            throw e;
        }
        catch (BackgroundException | IOException e) {
            throw new ChecksumException(e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoChecksumCompute{");
        sb.append("delegate=").append(this.delegate);
        sb.append('}');
        return sb.toString();
    }
}

