/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.features;

import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Vault;

public class CryptoAttributesFeature
implements AttributesFinder {
    private final Session<?> session;
    private final AttributesFinder delegate;
    private final Vault vault;

    public CryptoAttributesFeature(Session<?> session, AttributesFinder delegate, Vault cryptomator) {
        this.session = session;
        this.delegate = delegate;
        this.vault = cryptomator;
    }

    public PathAttributes find(Path file, ListProgressListener listener) throws BackgroundException {
        PathAttributes attributes = new PathAttributes(this.delegate.find(this.vault.encrypt(this.session, file, true), listener));
        if (file.isFile()) {
            attributes.setSize(this.vault.toCleartextSize(0L, attributes.getSize()));
        }
        if (file.isDirectory()) {
            attributes.setSize(-1L);
        }
        return attributes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoAttributesFeature{");
        sb.append("delegate=").append(this.delegate);
        sb.append('}');
        return sb.toString();
    }
}

