/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator;

import ch.cyberduck.core.cache.LRUCache;
import com.google.common.io.BaseEncoding;
import java.util.Arrays;
import java.util.Objects;
import org.cryptomator.cryptolib.api.AuthenticationFailedException;
import org.cryptomator.cryptolib.api.FileNameCryptor;

public class CryptorCache {
    public static final BaseEncoding BASE32 = BaseEncoding.base32();
    private final LRUCache<String, String> directoryIdCache = LRUCache.build((long)250L);
    private final LRUCache<CacheKey, String> decryptCache = LRUCache.build((long)5000L);
    private final LRUCache<CacheKey, String> encryptCache = LRUCache.build((long)5000L);
    private final FileNameCryptor impl;

    public CryptorCache(FileNameCryptor impl) {
        this.impl = impl;
    }

    public String hashDirectoryId(String cleartextDirectoryId) {
        if (!this.directoryIdCache.contains((Object)cleartextDirectoryId)) {
            this.directoryIdCache.put((Object)cleartextDirectoryId, (Object)this.impl.hashDirectoryId(cleartextDirectoryId));
        }
        return (String)this.directoryIdCache.get((Object)cleartextDirectoryId);
    }

    public String encryptFilename(BaseEncoding encoding, String cleartextName, byte[] associatedData) {
        CacheKey key = new CacheKey(encoding, cleartextName, associatedData);
        if (this.encryptCache.contains((Object)key)) {
            return (String)this.encryptCache.get((Object)key);
        }
        String ciphertextName = this.impl.encryptFilename(encoding, cleartextName, (byte[][])new byte[][]{associatedData});
        this.encryptCache.put((Object)key, (Object)ciphertextName);
        this.decryptCache.put((Object)new CacheKey(encoding, ciphertextName, associatedData), (Object)cleartextName);
        return ciphertextName;
    }

    public String decryptFilename(BaseEncoding encoding, String ciphertextName, byte[] associatedData) throws AuthenticationFailedException {
        CacheKey key = new CacheKey(encoding, ciphertextName, associatedData);
        if (this.decryptCache.contains((Object)key)) {
            return (String)this.decryptCache.get((Object)key);
        }
        String cleartextName = this.impl.decryptFilename(encoding, ciphertextName, (byte[][])new byte[][]{associatedData});
        this.decryptCache.put((Object)key, (Object)cleartextName);
        this.encryptCache.put((Object)new CacheKey(encoding, cleartextName, associatedData), (Object)ciphertextName);
        return cleartextName;
    }

    private static class CacheKey {
        private final BaseEncoding encoding;
        private final String value;
        private final byte[] data;

        public CacheKey(BaseEncoding encoding, String value, byte[] data) {
            this.encoding = encoding;
            this.value = value;
            this.data = data;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Objects.equals(this.encoding, cacheKey.encoding) && Objects.equals(this.value, cacheKey.value) && Arrays.equals(this.data, cacheKey.data);
        }

        public int hashCode() {
            int result = Objects.hash(this.encoding, this.value);
            result = 31 * result + Arrays.hashCode(this.data);
            return result;
        }
    }
}

