/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.PasswordStore;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SimplePathPredicate;
import ch.cyberduck.core.UUIDRandomStringService;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.cryptomator.ContentReader;
import ch.cyberduck.core.cryptomator.ContentWriter;
import ch.cyberduck.core.cryptomator.CryptoAclPermission;
import ch.cyberduck.core.cryptomator.CryptoAuthenticationException;
import ch.cyberduck.core.cryptomator.CryptoDirectory;
import ch.cyberduck.core.cryptomator.CryptoFilename;
import ch.cyberduck.core.cryptomator.CryptoFilenameMismatchException;
import ch.cyberduck.core.cryptomator.CryptoInvalidFilesizeException;
import ch.cyberduck.core.cryptomator.CryptorCache;
import ch.cyberduck.core.cryptomator.features.CryptoAttributesFeature;
import ch.cyberduck.core.cryptomator.features.CryptoBulkFeature;
import ch.cyberduck.core.cryptomator.features.CryptoCompressFeature;
import ch.cyberduck.core.cryptomator.features.CryptoCopyFeature;
import ch.cyberduck.core.cryptomator.features.CryptoDeleteV6Feature;
import ch.cyberduck.core.cryptomator.features.CryptoDeleteV7Feature;
import ch.cyberduck.core.cryptomator.features.CryptoDirectoryV6Feature;
import ch.cyberduck.core.cryptomator.features.CryptoDirectoryV7Feature;
import ch.cyberduck.core.cryptomator.features.CryptoDownloadFeature;
import ch.cyberduck.core.cryptomator.features.CryptoEncryptionFeature;
import ch.cyberduck.core.cryptomator.features.CryptoFileIdProvider;
import ch.cyberduck.core.cryptomator.features.CryptoFindV6Feature;
import ch.cyberduck.core.cryptomator.features.CryptoFindV7Feature;
import ch.cyberduck.core.cryptomator.features.CryptoHeadersFeature;
import ch.cyberduck.core.cryptomator.features.CryptoLifecycleFeature;
import ch.cyberduck.core.cryptomator.features.CryptoListService;
import ch.cyberduck.core.cryptomator.features.CryptoLocationFeature;
import ch.cyberduck.core.cryptomator.features.CryptoLockFeature;
import ch.cyberduck.core.cryptomator.features.CryptoLoggingFeature;
import ch.cyberduck.core.cryptomator.features.CryptoMoveV6Feature;
import ch.cyberduck.core.cryptomator.features.CryptoMoveV7Feature;
import ch.cyberduck.core.cryptomator.features.CryptoMultipartWriteFeature;
import ch.cyberduck.core.cryptomator.features.CryptoReadFeature;
import ch.cyberduck.core.cryptomator.features.CryptoRedundancyFeature;
import ch.cyberduck.core.cryptomator.features.CryptoSearchFeature;
import ch.cyberduck.core.cryptomator.features.CryptoSymlinkFeature;
import ch.cyberduck.core.cryptomator.features.CryptoTimestampFeature;
import ch.cyberduck.core.cryptomator.features.CryptoTouchFeature;
import ch.cyberduck.core.cryptomator.features.CryptoTransferAccelerationFeature;
import ch.cyberduck.core.cryptomator.features.CryptoUnixPermission;
import ch.cyberduck.core.cryptomator.features.CryptoUploadFeature;
import ch.cyberduck.core.cryptomator.features.CryptoUrlProvider;
import ch.cyberduck.core.cryptomator.features.CryptoVersionIdProvider;
import ch.cyberduck.core.cryptomator.features.CryptoVersioningFeature;
import ch.cyberduck.core.cryptomator.features.CryptoWriteFeature;
import ch.cyberduck.core.cryptomator.impl.CryptoDirectoryV6Provider;
import ch.cyberduck.core.cryptomator.impl.CryptoDirectoryV7Provider;
import ch.cyberduck.core.cryptomator.impl.CryptoFilenameV6Provider;
import ch.cyberduck.core.cryptomator.impl.CryptoFilenameV7Provider;
import ch.cyberduck.core.cryptomator.random.FastSecureRandomProvider;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.cyberduck.core.features.AclPermission;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Bulk;
import ch.cyberduck.core.features.Compress;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Download;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.features.FileIdProvider;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Headers;
import ch.cyberduck.core.features.Lifecycle;
import ch.cyberduck.core.features.Location;
import ch.cyberduck.core.features.Lock;
import ch.cyberduck.core.features.Logging;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Redundancy;
import ch.cyberduck.core.features.Search;
import ch.cyberduck.core.features.Symlink;
import ch.cyberduck.core.features.Timestamp;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.TransferAcceleration;
import ch.cyberduck.core.features.Trash;
import ch.cyberduck.core.features.UnixPermission;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.features.VersionIdProvider;
import ch.cyberduck.core.features.Versioning;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.shared.DefaultTouchFeature;
import ch.cyberduck.core.shared.DefaultUrlProvider;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.vault.DefaultVaultRegistry;
import ch.cyberduck.core.vault.VaultCredentials;
import ch.cyberduck.core.vault.VaultException;
import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.google.common.io.BaseEncoding;
import com.google.gson.JsonParseException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cryptomator.cryptolib.api.AuthenticationFailedException;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.CryptorProvider;
import org.cryptomator.cryptolib.api.FileContentCryptor;
import org.cryptomator.cryptolib.api.FileHeaderCryptor;
import org.cryptomator.cryptolib.api.InvalidPassphraseException;
import org.cryptomator.cryptolib.api.Masterkey;
import org.cryptomator.cryptolib.common.MasterkeyFile;
import org.cryptomator.cryptolib.common.MasterkeyFileAccess;

public class CryptoVault
implements Vault {
    private static final Logger log = LogManager.getLogger(CryptoVault.class);
    public static final int VAULT_VERSION_DEPRECATED = 6;
    public static final int VAULT_VERSION = PreferencesFactory.get().getInteger("cryptomator.vault.version");
    public static final byte[] VAULT_PEPPER = PreferencesFactory.get().getProperty("cryptomator.vault.pepper").getBytes(StandardCharsets.UTF_8);
    public static final String DIR_PREFIX = "0";
    private static final Pattern BASE32_PATTERN = Pattern.compile("^0?(([A-Z2-7]{8})*[A-Z2-7=]{8})");
    private static final Pattern BASE64URL_PATTERN = Pattern.compile("^([A-Za-z0-9_=-]+).c9r");
    private final Path home;
    private final Path masterkey;
    private final Path config;
    private final Path vault;
    private int vaultVersion;
    private final Preferences preferences = PreferencesFactory.get();
    private Cryptor cryptor;
    private CryptorCache fileNameCryptor;
    private CryptoFilename filenameProvider;
    private CryptoDirectory directoryProvider;
    private final byte[] pepper;

    public CryptoVault(Path home) {
        this(home, DefaultVaultRegistry.DEFAULT_MASTERKEY_FILE_NAME, DefaultVaultRegistry.DEFAULT_VAULTCONFIG_FILE_NAME, VAULT_PEPPER);
    }

    public CryptoVault(Path home, String masterkey, String config, byte[] pepper) {
        this.home = home;
        this.masterkey = new Path(home, masterkey, EnumSet.of(AbstractPath.Type.file, AbstractPath.Type.vault));
        this.config = new Path(home, config, EnumSet.of(AbstractPath.Type.file, AbstractPath.Type.vault));
        this.pepper = pepper;
        EnumSet<AbstractPath.Type> type = EnumSet.copyOf(home.getType());
        type.add(AbstractPath.Type.vault);
        this.vault = home.isRoot() ? new Path(home.getAbsolute(), type, new PathAttributes(home.attributes())) : new Path(home.getParent(), home.getName(), type, new PathAttributes(home.attributes()));
    }

    public synchronized Path create(Session<?> session, VaultCredentials credentials, PasswordStore keychain, int version) throws BackgroundException {
        MasterkeyFile masterkeyFile;
        Host bookmark = session.getHost();
        if (credentials.isSaved()) {
            try {
                keychain.addPassword(String.format("Cryptomator Passphrase (%s)", bookmark.getCredentials().getUsername()), new DefaultUrlProvider(bookmark).toUrl(this.masterkey).find(DescriptiveUrl.Type.provider).getUrl(), credentials.getPassword());
            }
            catch (LocalAccessDeniedException e) {
                log.error(String.format("Failure %s saving credentials for %s in password store", new Object[]{e, bookmark}));
            }
        }
        String passphrase = credentials.getPassword();
        ByteArrayOutputStream mkArray = new ByteArrayOutputStream();
        Masterkey mk = Masterkey.generate((SecureRandom)FastSecureRandomProvider.get().provide());
        MasterkeyFileAccess access = new MasterkeyFileAccess(this.pepper, FastSecureRandomProvider.get().provide());
        try {
            access.persist(mk, (OutputStream)mkArray, (CharSequence)passphrase, version);
            masterkeyFile = MasterkeyFile.read((Reader)new StringReader(new String(mkArray.toByteArray(), StandardCharsets.UTF_8)));
        }
        catch (IOException e) {
            throw new VaultException("Failure creating master key", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Write master key to %s", this.masterkey));
        }
        Directory directory = (Directory)session._getFeature(Directory.class);
        TransferStatus status = new TransferStatus();
        Encryption encryption = (Encryption)session.getFeature(Encryption.class);
        if (encryption != null) {
            status.setEncryption(encryption.getDefault(this.home));
        }
        Path vault = directory.mkdir(this.home, status);
        new ContentWriter(session).write(this.masterkey, mkArray.toByteArray());
        if (VAULT_VERSION == version) {
            Algorithm algorithm = Algorithm.HMAC256((byte[])mk.getEncoded());
            String conf = JWT.create().withJWTId(new UUIDRandomStringService().random()).withKeyId(String.format("masterkeyfile:%s", this.masterkey.getName())).withClaim("format", Integer.valueOf(version)).withClaim("cipherCombo", CryptorProvider.Scheme.SIV_CTRMAC.toString()).withClaim("shorteningThreshold", Integer.valueOf(220)).sign(algorithm);
            new ContentWriter(session).write(this.config, conf.getBytes(StandardCharsets.US_ASCII));
        }
        this.open(masterkeyFile, passphrase);
        Path secondLevel = this.directoryProvider.toEncrypted(session, this.home.attributes().getDirectoryId(), this.home);
        Path firstLevel = secondLevel.getParent();
        Path dataDir = firstLevel.getParent();
        if (log.isDebugEnabled()) {
            log.debug(String.format("Create vault root directory at %s", secondLevel));
        }
        directory.mkdir(dataDir, status);
        directory.mkdir(firstLevel, status);
        directory.mkdir(secondLevel, status);
        return vault;
    }

    public synchronized Path create(Session<?> session, String region, VaultCredentials credentials, PasswordStore keychain) throws BackgroundException {
        return this.create(session, credentials, keychain, VAULT_VERSION);
    }

    public synchronized CryptoVault load(Session<?> session, PasswordCallback prompt, PasswordStore keychain) throws BackgroundException {
        MasterkeyFile masterkeyFile;
        if (this.isUnlocked()) {
            log.warn(String.format("Skip unlock of open vault %s", this));
            return this;
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Attempt to read master key from %s", this.masterkey));
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Read master key %s", this.masterkey));
        }
        Host bookmark = session.getHost();
        String passphrase = keychain.getPassword(String.format("Cryptomator Passphrase (%s)", bookmark.getCredentials().getUsername()), new DefaultUrlProvider(bookmark).toUrl(this.masterkey).find(DescriptiveUrl.Type.provider).getUrl());
        if (null == passphrase) {
            passphrase = keychain.getPassword(String.format("Cryptomator Passphrase %s", bookmark.getHostname()), new DefaultUrlProvider(bookmark).toUrl(this.masterkey).find(DescriptiveUrl.Type.provider).getUrl());
        }
        try (Reader reader = new ContentReader(session).getReader(this.masterkey);){
            masterkeyFile = MasterkeyFile.read((Reader)reader);
        }
        catch (JsonParseException | IOException | IllegalArgumentException | IllegalStateException e) {
            throw new VaultException(String.format("Failure reading vault master key file %s", this.masterkey.getName()), e);
        }
        this.unlock(session, masterkeyFile, passphrase, bookmark, prompt, MessageFormat.format(LocaleFactory.localizedString((String)"Provide your passphrase to unlock the Cryptomator Vault {0}", (String)"Cryptomator"), this.home.getName()), keychain);
        return this;
    }

    private void unlock(Session<?> session, MasterkeyFile mkFile, String passphrase, Host bookmark, PasswordCallback prompt, String message, PasswordStore keychain) throws BackgroundException {
        VaultCredentials credentials;
        if (null == passphrase) {
            credentials = prompt.prompt(bookmark, LocaleFactory.localizedString((String)"Unlock Vault", (String)"Cryptomator"), message, new LoginOptions().user(false).anonymous(false).icon("cryptomator.tiff").passwordPlaceholder(LocaleFactory.localizedString((String)"Passphrase", (String)"Cryptomator")));
            if (null == credentials.getPassword()) {
                throw new LoginCanceledException();
            }
        } else {
            credentials = new VaultCredentials(passphrase).withSaved(this.preferences.getBoolean("vault.keychain"));
        }
        try {
            this.open(mkFile, credentials.getPassword());
            if (credentials.isSaved()) {
                if (log.isInfoEnabled()) {
                    log.info(String.format("Save passphrase for %s", this.masterkey));
                }
                keychain.addPassword(String.format("Cryptomator Passphrase (%s)", bookmark.getCredentials().getUsername()), new DefaultUrlProvider(bookmark).toUrl(this.masterkey).find(DescriptiveUrl.Type.provider).getUrl(), credentials.getPassword());
            }
        }
        catch (CryptoAuthenticationException e) {
            this.unlock(session, mkFile, null, bookmark, prompt, String.format("%s %s.", e.getDetail(), MessageFormat.format(LocaleFactory.localizedString((String)"Provide your passphrase to unlock the Cryptomator Vault {0}", (String)"Cryptomator"), this.home.getName())), keychain);
        }
    }

    public synchronized void close() {
        if (this.isUnlocked()) {
            if (log.isInfoEnabled()) {
                log.info(String.format("Close vault with cryptor %s", this.cryptor));
            }
            if (this.cryptor != null) {
                this.cryptor.destroy();
            }
            if (this.directoryProvider != null) {
                this.directoryProvider.destroy();
            }
            if (this.filenameProvider != null) {
                this.filenameProvider.destroy();
            }
        }
        this.cryptor = null;
        this.fileNameCryptor = null;
    }

    protected void open(MasterkeyFile mkFile, CharSequence passphrase) throws VaultException, CryptoAuthenticationException {
        switch (mkFile.version) {
            case 6: {
                this.open(mkFile, passphrase, new CryptoFilenameV6Provider(this.vault), new CryptoDirectoryV6Provider(this.vault, this));
                break;
            }
            default: {
                this.open(mkFile, passphrase, new CryptoFilenameV7Provider(), new CryptoDirectoryV7Provider(this.vault, this));
            }
        }
    }

    protected void open(MasterkeyFile mkFile, CharSequence passphrase, CryptoFilename filenameProvider, CryptoDirectory directoryProvider) throws VaultException, CryptoAuthenticationException {
        this.vaultVersion = mkFile.version;
        CryptorProvider provider = CryptorProvider.forScheme((CryptorProvider.Scheme)CryptorProvider.Scheme.SIV_CTRMAC);
        if (log.isDebugEnabled()) {
            log.debug(String.format("Initialized crypto provider %s", provider));
        }
        try {
            this.cryptor = provider.provide(this.getMasterKey(mkFile, passphrase), FastSecureRandomProvider.get().provide());
            this.fileNameCryptor = new CryptorCache(this.cryptor.fileNameCryptor());
            this.filenameProvider = filenameProvider;
            this.directoryProvider = directoryProvider;
        }
        catch (IOException | IllegalArgumentException e) {
            throw new VaultException("Failure reading key file", (Throwable)e);
        }
        catch (InvalidPassphraseException e) {
            throw new CryptoAuthenticationException("Failure to decrypt master key file", e);
        }
    }

    private Masterkey getMasterKey(MasterkeyFile mkFile, CharSequence passphrase) throws IOException {
        StringWriter writer = new StringWriter();
        mkFile.write((Writer)writer);
        return new MasterkeyFileAccess(this.pepper, FastSecureRandomProvider.get().provide()).load((InputStream)new ByteArrayInputStream(writer.getBuffer().toString().getBytes(StandardCharsets.UTF_8)), passphrase);
    }

    public synchronized boolean isUnlocked() {
        return this.cryptor != null;
    }

    public Vault.State getState() {
        return this.isUnlocked() ? Vault.State.open : Vault.State.closed;
    }

    public boolean contains(Path file) {
        if (this.isUnlocked()) {
            return new SimplePathPredicate(file).test(this.home) || file.isChild(this.home);
        }
        return false;
    }

    public Path encrypt(Session<?> session, Path file) throws BackgroundException {
        return this.encrypt(session, file, file.attributes().getDirectoryId(), false);
    }

    public Path encrypt(Session<?> session, Path file, boolean metadata) throws BackgroundException {
        return this.encrypt(session, file, file.attributes().getDirectoryId(), metadata);
    }

    public Path encrypt(Session<?> session, Path file, String directoryId, boolean metadata) throws BackgroundException {
        Path encrypted;
        if (file.isFile() || metadata) {
            String filename;
            Path parent;
            if (file.getType().contains(AbstractPath.Type.vault)) {
                log.warn(String.format("Skip file %s because it is marked as an internal vault path", file));
                return file;
            }
            if (new SimplePathPredicate(file).test(this.home)) {
                log.warn(String.format("Skip vault home %s because the root has no metadata file", file));
                return file;
            }
            if (file.getType().contains(AbstractPath.Type.encrypted)) {
                Path decrypted = file.attributes().getDecrypted();
                parent = this.directoryProvider.toEncrypted(session, decrypted.getParent().attributes().getDirectoryId(), decrypted.getParent());
                filename = this.directoryProvider.toEncrypted(session, parent.attributes().getDirectoryId(), decrypted.getName(), decrypted.getType());
            } else {
                parent = this.directoryProvider.toEncrypted(session, file.getParent().attributes().getDirectoryId(), file.getParent());
                filename = this.directoryProvider.toEncrypted(session, parent.attributes().getDirectoryId(), file.getName(), file.getType());
            }
            PathAttributes attributes = new PathAttributes(file.attributes());
            attributes.setDirectoryId(null);
            if (!file.isFile() && !metadata) {
                attributes.setVersionId(null);
                attributes.setFileId(null);
            }
            attributes.setSize(this.toCiphertextSize(0L, file.attributes().getSize()));
            EnumSet<AbstractPath.Type> type = EnumSet.copyOf(file.getType());
            if (metadata && this.vaultVersion == 6) {
                type.remove(AbstractPath.Type.directory);
                type.add(AbstractPath.Type.file);
            }
            type.remove(AbstractPath.Type.decrypted);
            type.add(AbstractPath.Type.encrypted);
            encrypted = new Path(parent, filename, type, attributes);
        } else {
            if (file.getType().contains(AbstractPath.Type.encrypted)) {
                log.warn(String.format("Skip file %s because it is already marked as an encrypted path", file));
                return file;
            }
            if (file.getType().contains(AbstractPath.Type.vault)) {
                return this.directoryProvider.toEncrypted(session, this.home.attributes().getDirectoryId(), this.home);
            }
            encrypted = this.directoryProvider.toEncrypted(session, directoryId, file);
        }
        if (!file.getType().contains(AbstractPath.Type.encrypted)) {
            encrypted.attributes().setDecrypted(file);
        }
        file.attributes().setVault(this.home);
        encrypted.attributes().setVault(this.home);
        return encrypted;
    }

    public Path decrypt(Session<?> session, Path file) throws BackgroundException {
        Path inflated;
        if (file.getType().contains(AbstractPath.Type.decrypted)) {
            log.warn(String.format("Skip file %s because it is already marked as an decrypted path", file));
            return file;
        }
        if (file.getType().contains(AbstractPath.Type.vault)) {
            log.warn(String.format("Skip file %s because it is marked as an internal vault path", file));
            return file;
        }
        Pattern pattern = this.vaultVersion == 6 ? BASE32_PATTERN : BASE64URL_PATTERN;
        Matcher m = pattern.matcher((inflated = this.inflate(session, file)).getName());
        if (m.matches()) {
            String ciphertext = m.group(1);
            try {
                String cleartextFilename = this.fileNameCryptor.decryptFilename(this.vaultVersion == 6 ? BaseEncoding.base32() : BaseEncoding.base64Url(), ciphertext, file.getParent().attributes().getDirectoryId().getBytes(StandardCharsets.UTF_8));
                PathAttributes attributes = new PathAttributes(file.attributes());
                if (this.isDirectory(inflated)) {
                    Permission permission = attributes.getPermission();
                    permission.setUser(permission.getUser().or(Permission.Action.execute));
                    permission.setGroup(permission.getGroup().or(Permission.Action.execute));
                    permission.setOther(permission.getOther().or(Permission.Action.execute));
                    attributes.setSize(-1L);
                    attributes.setVersionId(null);
                    attributes.setFileId(null);
                } else {
                    attributes.setSize(this.toCleartextSize(0L, file.attributes().getSize()));
                }
                attributes.setEncrypted(file);
                attributes.setVault(this.home);
                EnumSet<AbstractPath.Type> type = EnumSet.copyOf(file.getType());
                type.remove(this.isDirectory(inflated) ? AbstractPath.Type.file : AbstractPath.Type.directory);
                type.add(this.isDirectory(inflated) ? AbstractPath.Type.directory : AbstractPath.Type.file);
                type.remove(AbstractPath.Type.encrypted);
                type.add(AbstractPath.Type.decrypted);
                Path decrypted = new Path(file.getParent().attributes().getDecrypted(), cleartextFilename, type, attributes);
                if (type.contains(AbstractPath.Type.symboliclink)) {
                    decrypted.setSymlinkTarget(file.getSymlinkTarget());
                }
                return decrypted;
            }
            catch (AuthenticationFailedException e) {
                throw new CryptoAuthenticationException("Failure to decrypt due to an unauthentic ciphertext", e);
            }
        }
        throw new CryptoFilenameMismatchException(String.format("Failure to decrypt %s due to missing pattern match for %s", inflated.getName(), pattern));
    }

    private boolean isDirectory(Path p) {
        if (this.vaultVersion == 6) {
            return p.getName().startsWith(DIR_PREFIX);
        }
        return p.isDirectory();
    }

    public long toCiphertextSize(long cleartextFileOffset, long cleartextFileSize) {
        if (-1L == cleartextFileSize) {
            return -1L;
        }
        int headerSize = 0L == cleartextFileOffset ? this.cryptor.fileHeaderCryptor().headerSize() : 0;
        return (long)headerSize + this.cryptor.fileContentCryptor().ciphertextSize(cleartextFileSize);
    }

    public long toCleartextSize(long cleartextFileOffset, long ciphertextFileSize) throws CryptoInvalidFilesizeException {
        if (-1L == ciphertextFileSize) {
            return -1L;
        }
        int headerSize = 0L == cleartextFileOffset ? this.cryptor.fileHeaderCryptor().headerSize() : 0;
        try {
            return this.cryptor.fileContentCryptor().cleartextSize(ciphertextFileSize - (long)headerSize);
        }
        catch (AssertionError e) {
            throw new CryptoInvalidFilesizeException(String.format("Encrypted file size must be at least %d bytes", headerSize));
        }
        catch (IllegalArgumentException e) {
            throw new CryptoInvalidFilesizeException(String.format("Invalid file size. %s", e.getMessage()));
        }
    }

    private Path inflate(Session<?> session, Path file) throws BackgroundException {
        String fileName = file.getName();
        if (this.filenameProvider.isDeflated(fileName)) {
            String filename = this.filenameProvider.inflate(session, fileName);
            return new Path(file.getParent(), filename, EnumSet.of(AbstractPath.Type.file), file.attributes());
        }
        return file;
    }

    public Path getHome() {
        return this.home;
    }

    public Path getMasterkey() {
        return this.masterkey;
    }

    public Path getConfig() {
        return this.config;
    }

    public FileHeaderCryptor getFileHeaderCryptor() {
        return this.cryptor.fileHeaderCryptor();
    }

    public FileContentCryptor getFileContentCryptor() {
        return this.cryptor.fileContentCryptor();
    }

    public CryptorCache getFileNameCryptor() {
        return this.fileNameCryptor;
    }

    public CryptoFilename getFilenameProvider() {
        return this.filenameProvider;
    }

    public CryptoDirectory getDirectoryProvider() {
        return this.directoryProvider;
    }

    public int numberOfChunks(long cleartextFileSize) {
        return (int)(cleartextFileSize / (long)this.cryptor.fileContentCryptor().cleartextChunkSize() + (long)(cleartextFileSize % (long)this.cryptor.fileContentCryptor().cleartextChunkSize() > 0L ? 1 : 0));
    }

    public <T> T getFeature(Session<?> session, Class<T> type, T delegate) {
        if (this.isUnlocked()) {
            if (type == ListService.class) {
                return (T)new CryptoListService(session, (ListService)delegate, this);
            }
            if (type == Touch.class) {
                return (T)new CryptoTouchFeature(session, new DefaultTouchFeature((Write)session._getFeature(Write.class)), (Write)session._getFeature(Write.class), this);
            }
            if (type == Directory.class) {
                return (T)(this.vaultVersion == 6 ? new CryptoDirectoryV6Feature(session, (Directory)delegate, (Write)session._getFeature(Write.class), (Find)session._getFeature(Find.class), this) : new CryptoDirectoryV7Feature(session, (Directory)delegate, (Write)session._getFeature(Write.class), (Find)session._getFeature(Find.class), this));
            }
            if (type == Upload.class) {
                return (T)new CryptoUploadFeature(session, (Upload)delegate, (Write)session._getFeature(Write.class), this);
            }
            if (type == Download.class) {
                return (T)new CryptoDownloadFeature(session, (Download)delegate, (Read)session._getFeature(Read.class), this);
            }
            if (type == Read.class) {
                return (T)new CryptoReadFeature(session, (Read)delegate, this);
            }
            if (type == Write.class) {
                return (T)new CryptoWriteFeature(session, (Write)delegate, this);
            }
            if (type == MultipartWrite.class) {
                return (T)new CryptoMultipartWriteFeature(session, (Write)delegate, this);
            }
            if (type == Move.class) {
                return (T)(this.vaultVersion == 6 ? new CryptoMoveV6Feature(session, (Move)delegate, this) : new CryptoMoveV7Feature(session, (Move)delegate, this));
            }
            if (type == AttributesFinder.class) {
                return (T)new CryptoAttributesFeature(session, (AttributesFinder)delegate, this);
            }
            if (type == Find.class) {
                return (T)(this.vaultVersion == 6 ? new CryptoFindV6Feature(session, (Find)delegate, this) : new CryptoFindV7Feature(session, (Find)delegate, this));
            }
            if (type == UrlProvider.class) {
                return (T)new CryptoUrlProvider(session, (UrlProvider)delegate, this);
            }
            if (type == FileIdProvider.class) {
                return (T)new CryptoFileIdProvider(session, (FileIdProvider)delegate, this);
            }
            if (type == VersionIdProvider.class) {
                return (T)new CryptoVersionIdProvider(session, (VersionIdProvider)delegate, this);
            }
            if (type == Delete.class) {
                return (T)(this.vaultVersion == 6 ? new CryptoDeleteV6Feature(session, (Delete)delegate, this) : new CryptoDeleteV7Feature(session, (Delete)delegate, this));
            }
            if (type == Trash.class) {
                return (T)(this.vaultVersion == 6 ? new CryptoDeleteV6Feature(session, (Delete)delegate, this) : new CryptoDeleteV7Feature(session, (Delete)delegate, this));
            }
            if (type == Symlink.class) {
                return (T)new CryptoSymlinkFeature(session, (Symlink)delegate, this);
            }
            if (type == Headers.class) {
                return (T)new CryptoHeadersFeature(session, (Headers)delegate, this);
            }
            if (type == Compress.class) {
                return (T)new CryptoCompressFeature(session, (Compress)delegate, this);
            }
            if (type == Bulk.class) {
                return (T)new CryptoBulkFeature(session, (Bulk)delegate, (Delete)session._getFeature(Delete.class), this);
            }
            if (type == UnixPermission.class) {
                return (T)new CryptoUnixPermission(session, (UnixPermission)delegate, this);
            }
            if (type == AclPermission.class) {
                return (T)new CryptoAclPermission(session, (AclPermission)delegate, this);
            }
            if (type == Copy.class) {
                return (T)new CryptoCopyFeature(session, (Copy)delegate, this);
            }
            if (type == Timestamp.class) {
                return (T)new CryptoTimestampFeature(session, (Timestamp)delegate, this);
            }
            if (type == Encryption.class) {
                return (T)new CryptoEncryptionFeature(session, (Encryption)delegate, this);
            }
            if (type == Lifecycle.class) {
                return (T)new CryptoLifecycleFeature(session, (Lifecycle)delegate, this);
            }
            if (type == Location.class) {
                return (T)new CryptoLocationFeature(session, (Location)delegate, this);
            }
            if (type == Lock.class) {
                return (T)new CryptoLockFeature(session, (Lock)delegate, this);
            }
            if (type == Logging.class) {
                return (T)new CryptoLoggingFeature(session, (Logging)delegate, this);
            }
            if (type == Redundancy.class) {
                return (T)new CryptoRedundancyFeature(session, (Redundancy)delegate, this);
            }
            if (type == Search.class) {
                return (T)new CryptoSearchFeature(session, (Search)delegate, this);
            }
            if (type == TransferAcceleration.class) {
                return (T)new CryptoTransferAccelerationFeature(session, (TransferAcceleration)delegate, this);
            }
            if (type == Versioning.class) {
                return (T)new CryptoVersioningFeature(session, (Versioning)delegate, this);
            }
        }
        return delegate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CryptoVault)) {
            return false;
        }
        CryptoVault that = (CryptoVault)o;
        return new SimplePathPredicate(this.home).test(that.home);
    }

    public int hashCode() {
        return Objects.hash(this.home);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoVault{");
        sb.append("home=").append(this.home);
        sb.append(", cryptor=").append(this.cryptor);
        sb.append('}');
        return sb.toString();
    }
}

