/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.DefaultStreamCloser;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class ContentWriter {
    private final Session<?> session;

    public ContentWriter(Session<?> session) {
        this.session = session;
    }

    public void write(Path file, byte[] content) throws BackgroundException {
        this.write(file, content, new TransferStatus());
    }

    public void write(Path file, byte[] content, TransferStatus status) throws BackgroundException {
        Write write = (Write)this.session._getFeature(Write.class);
        status.setLength((long)content.length);
        status.setChecksum(write.checksum(file, status).compute((InputStream)new ByteArrayInputStream(content), status));
        Encryption encryption = (Encryption)this.session.getFeature(Encryption.class);
        if (encryption != null) {
            status.setEncryption(encryption.getDefault(file));
        }
        StatusOutputStream out = write.write(file, status, (ConnectionCallback)new DisabledConnectionCallback());
        try {
            IOUtils.write((byte[])content, (OutputStream)out);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
        finally {
            new DefaultStreamCloser().close((OutputStream)out);
        }
    }
}

