/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.openstack.swift.handler;

import ch.iterate.openstack.swift.Constants;
import ch.iterate.openstack.swift.Response;
import ch.iterate.openstack.swift.exception.AuthorizationException;
import ch.iterate.openstack.swift.exception.GenericException;
import ch.iterate.openstack.swift.exception.NotFoundException;
import ch.iterate.openstack.swift.handler.MetadataResponseHandler;
import ch.iterate.openstack.swift.model.ObjectMetadata;
import java.io.IOException;
import java.util.Locale;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;

public class ObjectMetadataResponseHandler
extends MetadataResponseHandler
implements ResponseHandler<ObjectMetadata> {
    public ObjectMetadata handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
        if (response.getStatusLine().getStatusCode() == 204 || response.getStatusLine().getStatusCode() == 200) {
            ObjectMetadata metadata = new ObjectMetadata(this.getContentType(response), this.getContentLength(response), this.getETag(response), this.getTimestamp(response));
            for (Header h : response.getAllHeaders()) {
                if (!h.getName().startsWith("X-Object-Meta-") && !Constants.HTTP_HEADER_EDITABLE_NAMES.contains(h.getName().toLowerCase(Locale.ENGLISH))) continue;
                metadata.addMetaData(h.getName(), h.getValue());
            }
            return metadata;
        }
        if (response.getStatusLine().getStatusCode() == 404) {
            throw new NotFoundException(new Response(response));
        }
        if (response.getStatusLine().getStatusCode() == 401) {
            throw new AuthorizationException(new Response(response));
        }
        throw new GenericException(new Response(response));
    }
}

