/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client.crypto;

import com.joyent.manta.client.crypto.ByteRangeConversion;
import com.joyent.manta.exception.MantaClientEncryptionException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.crypto.macs.HMac;

public interface SupportedCipherDetails {
    public String getKeyGenerationAlgorithm();

    public String getCipherId();

    public String getCipherAlgorithm();

    public int getKeyLengthBits();

    public int getBlockSizeInBytes();

    public int getIVLengthInBytes();

    public int getAuthenticationTagOrHmacLengthInBytes();

    public long getMaximumPlaintextSizeInBytes();

    public Cipher getCipher();

    @Deprecated
    public Cipher getBouncyCastleCipher();

    public Cipher getCloneableCipher();

    public long ciphertextSize(long var1);

    public long plaintextSize(long var1);

    public boolean plaintextSizeCalculationIsAnEstimate();

    public boolean isAEADCipher();

    public AlgorithmParameterSpec getEncryptionParameterSpec(byte[] var1);

    public AlgorithmParameterSpec getEncryptionParameterSpec(byte[] var1, long var2);

    public HMac getAuthenticationHmac();

    public ByteRangeConversion translateByteRange(long var1, long var3);

    public long updateCipherToPosition(Cipher var1, long var2);

    public byte[] generateIv();

    public boolean supportsRandomAccess();

    public static Cipher findCipher(String cipherName, Provider provider) {
        try {
            return Cipher.getInstance(cipherName, provider);
        }
        catch (NoSuchAlgorithmException e) {
            String msg = String.format("Couldn't find algorithm [%s] via the [%s] provider", cipherName, provider.getName());
            throw new MantaClientEncryptionException(msg, e);
        }
        catch (NoSuchPaddingException e) {
            String[] split = StringUtils.split((String)cipherName, (String)"/", (int)3);
            if (split.length >= 3) {
                String padding = split[2];
                String msg = String.format("Invalid padding mode specified: %s", padding);
                throw new MantaClientEncryptionException(msg, e);
            }
            throw new MantaClientEncryptionException(e);
        }
    }
}

