/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.irods;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.irods.IRODSExceptionMappingService;
import ch.cyberduck.core.irods.IRODSSession;
import ch.cyberduck.core.shared.AppendWriteFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.worker.DefaultExceptionMappingService;
import java.io.OutputStream;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.JargonRuntimeException;
import org.irods.jargon.core.packinstr.DataObjInp;
import org.irods.jargon.core.pub.IRODSFileSystemAO;
import org.irods.jargon.core.pub.domain.ObjStat;
import org.irods.jargon.core.pub.io.IRODSFileOutputStream;
import org.irods.jargon.core.pub.io.PackingIrodsOutputStream;

public class IRODSWriteFeature
extends AppendWriteFeature<ObjStat> {
    private final IRODSSession session;

    public IRODSWriteFeature(IRODSSession session) {
        this.session = session;
    }

    public StatusOutputStream<ObjStat> write(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            try {
                IRODSFileSystemAO fs = (IRODSFileSystemAO)this.session.getClient();
                IRODSFileOutputStream out = fs.getIRODSFileFactory().instanceIRODSFileOutputStream(file.getAbsolute(), status.isAppend() ? DataObjInp.OpenFlags.READ_WRITE : DataObjInp.OpenFlags.WRITE_TRUNCATE);
                return new StatusOutputStream<ObjStat>((OutputStream)new PackingIrodsOutputStream(out)){

                    public ObjStat getStatus() {
                        return null;
                    }
                };
            }
            catch (JargonRuntimeException e) {
                if (e.getCause() instanceof JargonException) {
                    throw (JargonException)e.getCause();
                }
                throw new DefaultExceptionMappingService().map((Throwable)e);
            }
        }
        catch (JargonException e) {
            throw new IRODSExceptionMappingService().map("Uploading {0} failed", e, file);
        }
    }
}

