/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.irods;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ChecksumException;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.ChecksumComputeFactory;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.irods.DefaultTransferOptionsConfigurer;
import ch.cyberduck.core.irods.DefaultTransferStatusCallbackListener;
import ch.cyberduck.core.irods.IRODSExceptionMappingService;
import ch.cyberduck.core.irods.IRODSSession;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.File;
import java.text.MessageFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.irods.jargon.core.checksum.ChecksumValue;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.TransferOptions;
import org.irods.jargon.core.pub.DataObjectChecksumUtilitiesAO;
import org.irods.jargon.core.pub.DataTransferOperations;
import org.irods.jargon.core.pub.IRODSFileSystemAO;
import org.irods.jargon.core.pub.io.IRODSFile;
import org.irods.jargon.core.transfer.DefaultTransferControlBlock;
import org.irods.jargon.core.transfer.TransferControlBlock;
import org.irods.jargon.core.transfer.TransferStatusCallbackListener;

public class IRODSUploadFeature
implements Upload<Checksum> {
    private static final Logger log = LogManager.getLogger(IRODSUploadFeature.class);
    private final IRODSSession session;

    public IRODSUploadFeature(IRODSSession session) {
        this.session = session;
    }

    public Checksum upload(Path file, Local local, BandwidthThrottle throttle, StreamListener listener, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            IRODSFileSystemAO fs = (IRODSFileSystemAO)this.session.getClient();
            IRODSFile f = fs.getIRODSFileFactory().instanceIRODSFile(file.getAbsolute());
            TransferControlBlock block = DefaultTransferControlBlock.instance((String)"", (int)new HostPreferences(this.session.getHost()).getInteger("connection.retry"));
            TransferOptions options = new DefaultTransferOptionsConfigurer().configure(new TransferOptions());
            if (Host.TransferType.unknown.equals((Object)this.session.getHost().getTransferType())) {
                options.setUseParallelTransfer(Host.TransferType.valueOf((String)PreferencesFactory.get().getProperty("queue.transfer.type")).equals((Object)Host.TransferType.concurrent));
            } else {
                options.setUseParallelTransfer(this.session.getHost().getTransferType().equals((Object)Host.TransferType.concurrent));
            }
            block.setTransferOptions(options);
            DataTransferOperations transfer = fs.getIRODSAccessObjectFactory().getDataTransferOperations(fs.getIRODSAccount());
            transfer.putOperation(new File(local.getAbsolute()), f, (TransferStatusCallbackListener)new DefaultTransferStatusCallbackListener(status, listener, block), block);
            if (status.isComplete()) {
                DataObjectChecksumUtilitiesAO checksum = fs.getIRODSAccessObjectFactory().getDataObjectChecksumUtilitiesAO(fs.getIRODSAccount());
                ChecksumValue value = checksum.computeChecksumOnDataObject(f);
                Checksum fingerprint = Checksum.parse((String)value.getChecksumStringValue());
                if (null == fingerprint) {
                    log.warn(String.format("Unsupported checksum algorithm %s", value.getChecksumEncoding()));
                } else if (file.getType().contains(AbstractPath.Type.encrypted)) {
                    log.warn(String.format("Skip checksum verification for %s with client side encryption enabled", file));
                } else {
                    Checksum expected = ChecksumComputeFactory.get((HashAlgorithm)fingerprint.algorithm).compute(local.getInputStream(), new TransferStatus(status));
                    if (!expected.equals((Object)fingerprint)) {
                        throw new ChecksumException(MessageFormat.format(LocaleFactory.localizedString((String)"Upload {0} failed", (String)"Error"), file.getName()), MessageFormat.format("Mismatch between {0} hash {1} of uploaded data and ETag {2} returned by the server", fingerprint.algorithm.toString(), expected, fingerprint.hash));
                    }
                }
                return fingerprint;
            }
            return null;
        }
        catch (JargonException e) {
            throw new IRODSExceptionMappingService().map(e);
        }
    }

    public Write.Append append(Path file, TransferStatus status) throws BackgroundException {
        return Write.override;
    }

    public Upload<Checksum> withWriter(Write<Checksum> writer) {
        return this;
    }
}

