/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.irods;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.io.StreamCopier;
import ch.cyberduck.core.irods.IRODSExceptionMappingService;
import ch.cyberduck.core.irods.IRODSSession;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.worker.DefaultExceptionMappingService;
import java.io.InputStream;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.JargonRuntimeException;
import org.irods.jargon.core.pub.IRODSFileSystemAO;
import org.irods.jargon.core.pub.io.IRODSFile;
import org.irods.jargon.core.pub.io.IRODSFileFactory;
import org.irods.jargon.core.pub.io.PackingIrodsInputStream;

public class IRODSReadFeature
implements Read {
    private final IRODSSession session;

    public IRODSReadFeature(IRODSSession session) {
        this.session = session;
    }

    public InputStream read(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            try {
                IRODSFileSystemAO fs = (IRODSFileSystemAO)this.session.getClient();
                IRODSFileFactory factory = fs.getIRODSFileFactory();
                IRODSFile f = factory.instanceIRODSFile(file.getAbsolute());
                if (f.exists()) {
                    PackingIrodsInputStream in = new PackingIrodsInputStream(factory.instanceIRODSFileInputStream(f));
                    if (status.isAppend()) {
                        return StreamCopier.skip((InputStream)in, (long)status.getOffset());
                    }
                    return in;
                }
                throw new NotfoundException(file.getAbsolute());
            }
            catch (JargonRuntimeException e) {
                if (e.getCause() instanceof JargonException) {
                    throw (JargonException)e.getCause();
                }
                throw new DefaultExceptionMappingService().map((Throwable)e);
            }
        }
        catch (JargonException e) {
            throw new IRODSExceptionMappingService().map("Download {0} failed", e, file);
        }
    }
}

