/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.irods;

import ch.cyberduck.core.BytecountStreamListener;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.transfer.TransferStatus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.irods.jargon.core.transfer.TransferControlBlock;
import org.irods.jargon.core.transfer.TransferStatusCallbackListener;

public class DefaultTransferStatusCallbackListener
implements TransferStatusCallbackListener {
    private static final Logger log = LogManager.getLogger(DefaultTransferStatusCallbackListener.class);
    private final TransferStatus status;
    private final BytecountStreamListener listener;
    private final TransferControlBlock block;

    public DefaultTransferStatusCallbackListener(TransferStatus status, StreamListener listener, TransferControlBlock block) {
        this.status = status;
        this.listener = new BytecountStreamListener(listener);
        this.block = block;
    }

    public TransferStatusCallbackListener.FileStatusCallbackResponse statusCallback(org.irods.jargon.core.transfer.TransferStatus t) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Progress with %s", t));
        }
        long bytes = t.getBytesTransfered() - this.listener.getSent();
        switch (t.getTransferType()) {
            case GET: {
                this.listener.recv(bytes);
                break;
            }
            case PUT: {
                this.listener.sent(bytes);
            }
        }
        try {
            this.status.validate();
            if (!t.isIntraFileStatusReport() && t.getTotalFilesTransferredSoFar() == t.getTotalFilesToTransfer()) {
                this.status.setComplete();
            }
        }
        catch (ConnectionCanceledException e) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Set canceled for block %s", this.block));
            }
            this.block.setCancelled(true);
            return TransferStatusCallbackListener.FileStatusCallbackResponse.SKIP;
        }
        return TransferStatusCallbackListener.FileStatusCallbackResponse.CONTINUE;
    }

    public void overallStatusCallback(org.irods.jargon.core.transfer.TransferStatus t) {
    }

    public TransferStatusCallbackListener.CallbackResponse transferAsksWhetherToForceOperation(String irodsAbsolutePath, boolean isCollection) {
        try {
            this.status.validate();
        }
        catch (ConnectionCanceledException e) {
            return TransferStatusCallbackListener.CallbackResponse.CANCEL;
        }
        if (this.status.isAppend()) {
            return TransferStatusCallbackListener.CallbackResponse.NO_THIS_FILE;
        }
        return TransferStatusCallbackListener.CallbackResponse.YES_THIS_FILE;
    }
}

