/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs.nfs;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.iterate.mountainduck.fs.nfs.KextManager;
import ch.iterate.mountainduck.fs.nfs.MountAccessDeniedException;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExecKextManagerService
implements KextManager {
    private static final Logger log = LogManager.getLogger((String)ExecKextManagerService.class.getName());

    @Override
    public void load(String bundleIdentifier) throws BackgroundException {
        try {
            int error = new ProcessBuilder("/sbin/kextload", "-b", bundleIdentifier).start().waitFor();
            if (0 != error) {
                if (log.isWarnEnabled()) {
                    log.warn(String.format("Loading kext %s returned error code %d", bundleIdentifier, error));
                }
                throw new MountAccessDeniedException(error);
            }
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
        catch (InterruptedException e) {
            throw new BackgroundException((Throwable)e);
        }
    }
}

